<?php
// don't load directly
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'TF_icon' ) ) {
	class TF_icon extends TF_Fields {

		public function __construct( $field, $value = '', $settings_id = '', $parent_field = '' ) {
			parent::__construct( $field, $value, $settings_id, $parent_field );

			//tf_icon_modal method load single time
			static $tf_icon_modal;
			if ( ! $tf_icon_modal ) {
				$tf_icon_modal = true;
				add_action( 'admin_footer', array( $this, 'tf_icon_modal' ) );
			}
		}

		public function render() {

			$default       = isset( $this->field['default'] ) ? $this->field['default'] : '';
			$value         = $this->value ? $this->value : '';
			$preview_class = $value ? 'tf-icon-preview' : 'tf-icon-preview tf-hide';
			$uniqueid      = uniqid();
			?>
            <div class="tf-icon-select" id="tf-icon-<?php echo esc_attr( $this->field['id'] . $uniqueid ); ?>">
                <div class="<?php echo esc_attr( $preview_class ); ?>">
                    <span class="tf-icon-preview-wrap tf-modal-btn">
                        <i class="<?php echo esc_attr( $value ); ?>"></i>
                    </span>
                    <span class="remove-icon">
                        <i class="ri-close-line"></i>
                    </span>
                </div>
                <a href="#" class="tf-admin-btn tf-modal-btn"><i class="ri-add-fill"></i><?php esc_html_e( 'Add Icon', 'bafg' ); ?></a>
                <input type="hidden" class="tf-icon-value" name="<?php echo esc_attr( $this->field_name() ); ?>" value="<?php echo esc_attr( $value ); ?>" <?php echo esc_attr($this->field_attributes()) ?>/>
            </div>
			<?php
		}

		public function tf_icon_modal() {
			?>
            <div class="tf-modal" id="tf-icon-modal" data-icon-field="">
                <div class="tf-modal-dialog">
                    <div class="container tf-modal-content">
                        <div class="tf-modal-header">
                            <div class="tf-icon-search">
                                <input type="text" placeholder="<?php esc_html_e( 'Search', 'bafg' ); ?>" class="tf-icon-search-input"/>
                            </div>
                            <a data-dismiss="modal" class="tf-modal-close">&#10005;</a>
                        </div>
                        <div class="tf-modal-body">
                            <div class="tf-icon-wrapper">
                                <ul class="tf-icon-tab-list">
									<?php
									$count     = 0;
									$icon_list = $this->get_icon_list();
									foreach ( $icon_list as $key => $value ) :
										if ( $value['icons'] ):
											?>
                                            <li class="tf-icon-tab <?php echo $count == 0 ? 'active' : '' ?>" data-tab="tf-icon-tab-<?php echo esc_attr( $key ) ?>">
                                                <i class="<?php echo esc_attr( $value['label_icon'] ) ?>"></i><?php echo esc_html( $value['label'] ); ?>
                                            </li>
										<?php
										endif;
										$count ++;
									endforeach; ?>
                                </ul>
                                <div class="tf-icon-tab-content">
									<?php
									$count     = 0;
									$icon_list = $this->get_icon_list();
									foreach ( $icon_list as $key => $value ) :
										?>
                                        <div class="tf-icon-tab-pane <?php echo $count == 0 ? 'active' : '' ?>" id="tf-icon-tab-<?php echo esc_attr( $key ) ?>">
                                            <ul class="tf-icon-list">
												<?php
												if ( $value['icons'] ):
													foreach ( $value['icons'] as $icon ) :
														?>
                                                        <li data-icon="<?php echo esc_attr( $icon ); ?>">
                                                            <div class="tf-icon-inner">
                                                                <i title="<?php echo esc_attr( $icon ); ?>" class="tf-main-icon <?php echo esc_attr( $icon ); ?>"></i>

                                                                <span class="check-icon">
                                                                    <i class="ri-check-line"></i>
                                                                </span>
                                                            </div>
                                                        </li>
													<?php endforeach;
												endif; ?>
                                            </ul>
                                        </div>
										<?php $count ++;
									endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <div class="tf-modal-footer">
                            <a class="tf-icon-insert tf-admin-btn tf-btn-secondary disabled"><?php esc_html_e( 'Insert', 'bafg' ); ?></a>
                        </div>
                    </div>
                </div>
            </div>
			<?php
		}

		public function get_icon_list() {
			$icons = array(
				'fontawesome_4' => array(
					'label'      => __( 'Font Awesome 4', 'bafg' ),
					'label_icon' => 'fa-regular fa-font-awesome',
					'icons'      => $this->fontawesome_four_icons(),
				),
				'fontawesome_5' => array(
					'label'      => __( 'Font Awesome 5', 'bafg' ),
					'label_icon' => 'fa-regular fa-font-awesome',
					'icons'      => $this->fontawesome_five_icons(),
				),
				'fontawesome_6' => array(
					'label'      => __( 'Font Awesome 6', 'bafg' ),
					'label_icon' => 'fa-regular fa-font-awesome',
					'icons'      => $this->fontawesome_six_icons(),
				),
				'remixicon'     => array(
					'label'      => __( 'Remix Icon', 'bafg' ),
					'label_icon' => 'ri-remixicon-line',
					'icons'      => $this->remix_icon(),
				),
			);

			$icons = apply_filters( 'tf_icon_list', $icons );

			return $icons;
		}

		public function fontawesome_four_icons() {
			$icons = array(
				'fa fa-glass',
				'fa fa-music',
				'fa fa-search',
				'fa fa-envelope-o',
				'fa fa-heart',
				'fa fa-star',
				'fa fa-star-o',
				'fa fa-user',
				'fa fa-film',
				'fa fa-th-large',
				'fa fa-th',
				'fa fa-th-list',
				'fa fa-check',
				'fa fa-times',
				'fa fa-search-plus',
				'fa fa-search-minus',
				'fa fa-power-off',
				'fa fa-signal',
				'fa fa-cog',
				'fa fa-trash-o',
				'fa fa-home',
				'fa fa-file-o',
				'fa fa-clock-o',
				'fa fa-road',
				'fa fa-download',
				'fa fa-arrow-circle-o-down',
				'fa fa-arrow-circle-o-up',
				'fa fa-inbox',
				'fa fa-play-circle-o',
				'fa fa-repeat',
				'fa fa-refresh',
				'fa fa-list-alt',
				'fa fa-lock',
				'fa fa-flag',
				'fa fa-headphones',
				'fa fa-volume-off',
				'fa fa-volume-down',
				'fa fa-volume-up',
				'fa fa-qrcode',
				'fa fa-barcode',
				'fa fa-tag',
				'fa fa-tags',
				'fa fa-book',
				'fa fa-bookmark',
				'fa fa-print',
				'fa fa-camera',
				'fa fa-font',
				'fa fa-bold',
				'fa fa-italic',
				'fa fa-text-height',
				'fa fa-text-width',
				'fa fa-align-left',
				'fa fa-align-center',
				'fa fa-align-right',
				'fa fa-align-justify',
				'fa fa-list',
				'fa fa-outdent',
				'fa fa-indent',
				'fa fa-video-camera',
				'fa fa-picture-o',
				'fa fa-pencil',
				'fa fa-map-marker',
				'fa fa-adjust',
				'fa fa-tint',
				'fa fa-pencil-square-o',
				'fa fa-share-square-o',
				'fa fa-check-square-o',
				'fa fa-arrows',
				'fa fa-step-backward',
				'fa fa-fast-backward',
				'fa fa-backward',
				'fa fa-play',
				'fa fa-pause',
				'fa fa-stop',
				'fa fa-forward',
				'fa fa-fast-forward',
				'fa fa-step-forward',
				'fa fa-eject',
				'fa fa-chevron-left',
				'fa fa-chevron-right',
				'fa fa-plus-circle',
				'fa fa-minus-circle',
				'fa fa-times-circle',
				'fa fa-check-circle',
				'fa fa-question-circle',
				'fa fa-info-circle',
				'fa fa-crosshairs',
				'fa fa-times-circle-o',
				'fa fa-check-circle-o',
				'fa fa-ban',
				'fa fa-arrow-left',
				'fa fa-arrow-right',
				'fa fa-arrow-up',
				'fa fa-arrow-down',
				'fa fa-share',
				'fa fa-expand',
				'fa fa-compress',
				'fa fa-plus',
				'fa fa-minus',
				'fa fa-asterisk',
				'fa fa-exclamation-circle',
				'fa fa-gift',
				'fa fa-leaf',
				'fa fa-fire',
				'fa fa-eye',
				'fa fa-eye-slash',
				'fa fa-exclamation-triangle',
				'fa fa-plane',
				'fa fa-calendar',
				'fa fa-random',
				'fa fa-comment',
				'fa fa-magnet',
				'fa fa-chevron-up',
				'fa fa-chevron-down',
				'fa fa-retweet',
				'fa fa-shopping-cart',
				'fa fa-folder',
				'fa fa-folder-open',
				'fa fa-arrows-v',
				'fa fa-arrows-h',
				'fa fa-bar-chart',
				'fa fa-twitter-square',
				'fa fa-facebook-square',
				'fa fa-camera-retro',
				'fa fa-key',
				'fa fa-cogs',
				'fa fa-comments',
				'fa fa-thumbs-o-up',
				'fa fa-thumbs-o-down',
				'fa fa-star-half',
				'fa fa-heart-o',
				'fa fa-sign-out',
				'fa fa-linkedin-square',
				'fa fa-thumb-tack',
				'fa fa-external-link',
				'fa fa-sign-in',
				'fa fa-trophy',
				'fa fa-github-square',
				'fa fa-upload',
				'fa fa-lemon-o',
				'fa fa-phone',
				'fa fa-square-o',
				'fa fa-bookmark-o',
				'fa fa-phone-square',
				'fa fa-twitter',
				'fa fa-facebook',
				'fa fa-github',
				'fa fa-unlock',
				'fa fa-credit-card',
				'fa fa-rss',
				'fa fa-hdd-o',
				'fa fa-bullhorn',
				'fa fa-bell',
				'fa fa-certificate',
				'fa fa-hand-o-right',
				'fa fa-hand-o-left',
				'fa fa-hand-o-up',
				'fa fa-hand-o-down',
				'fa fa-arrow-circle-left',
				'fa fa-arrow-circle-right',
				'fa fa-arrow-circle-up',
				'fa fa-arrow-circle-down',
				'fa fa-globe',
				'fa fa-wrench',
				'fa fa-tasks',
				'fa fa-filter',
				'fa fa-briefcase',
				'fa fa-arrows-alt',
				'fa fa-users',
				'fa fa-link',
				'fa fa-cloud',
				'fa fa-flask',
				'fa fa-scissors',
				'fa fa-files-o',
				'fa fa-paperclip',
				'fa fa-floppy-o',
				'fa fa-square',
				'fa fa-bars',
				'fa fa-list-ul',
				'fa fa-list-ol',
				'fa fa-strikethrough',
				'fa fa-underline',
				'fa fa-table',
				'fa fa-magic',
				'fa fa-truck',
				'fa fa-pinterest',
				'fa fa-pinterest-square',
				'fa fa-google-plus-square',
				'fa fa-google-plus',
				'fa fa-money',
				'fa fa-caret-down',
				'fa fa-caret-up',
				'fa fa-caret-left',
				'fa fa-caret-right',
				'fa fa-columns',
				'fa fa-sort',
				'fa fa-sort-desc',
				'fa fa-sort-asc',
				'fa fa-envelope',
				'fa fa-linkedin',
				'fa fa-undo',
				'fa fa-gavel',
				'fa fa-tachometer',
				'fa fa-comment-o',
				'fa fa-comments-o',
				'fa fa-bolt',
				'fa fa-sitemap',
				'fa fa-umbrella',
				'fa fa-clipboard',
				'fa fa-lightbulb-o',
				'fa fa-exchange',
				'fa fa-cloud-download',
				'fa fa-cloud-upload',
				'fa fa-user-md',
				'fa fa-stethoscope',
				'fa fa-suitcase',
				'fa fa-bell-o',
				'fa fa-coffee',
				'fa fa-cutlery',
				'fa fa-file-text-o',
				'fa fa-building-o',
				'fa fa-hospital-o',
				'fa fa-ambulance',
				'fa fa-medkit',
				'fa fa-fighter-jet',
				'fa fa-beer',
				'fa fa-h-square',
				'fa fa-plus-square',
				'fa fa-angle-double-left',
				'fa fa-angle-double-right',
				'fa fa-angle-double-up',
				'fa fa-angle-double-down',
				'fa fa-angle-left',
				'fa fa-angle-right',
				'fa fa-angle-up',
				'fa fa-angle-down',
				'fa fa-desktop',
				'fa fa-laptop',
				'fa fa-tablet',
				'fa fa-mobile',
				'fa fa-circle-o',
				'fa fa-quote-left',
				'fa fa-quote-right',
				'fa fa-spinner',
				'fa fa-circle',
				'fa fa-reply',
				'fa fa-github-alt',
				'fa fa-folder-o',
				'fa fa-folder-open-o',
				'fa fa-smile-o',
				'fa fa-frown-o',
				'fa fa-meh-o',
				'fa fa-gamepad',
				'fa fa-keyboard-o',
				'fa fa-flag-o',
				'fa fa-flag-checkered',
				'fa fa-terminal',
				'fa fa-code',
				'fa fa-reply-all',
				'fa fa-star-half-o',
				'fa fa-location-arrow',
				'fa fa-crop',
				'fa fa-code-fork',
				'fa fa-chain-broken',
				'fa fa-question',
				'fa fa-info',
				'fa fa-exclamation',
				'fa fa-superscript',
				'fa fa-subscript',
				'fa fa-eraser',
				'fa fa-puzzle-piece',
				'fa fa-microphone',
				'fa fa-microphone-slash',
				'fa fa-shield',
				'fa fa-calendar-o',
				'fa fa-fire-extinguisher',
				'fa fa-rocket',
				'fa fa-maxcdn',
				'fa fa-chevron-circle-left',
				'fa fa-chevron-circle-right',
				'fa fa-chevron-circle-up',
				'fa fa-chevron-circle-down',
				'fa fa-html5',
				'fa fa-css3',
				'fa fa-anchor',
				'fa fa-unlock-alt',
				'fa fa-bullseye',
				'fa fa-ellipsis-h',
				'fa fa-ellipsis-v',
				'fa fa-rss-square',
				'fa fa-play-circle',
				'fa fa-ticket',
				'fa fa-minus-square',
				'fa fa-minus-square-o',
				'fa fa-level-up',
				'fa fa-level-down',
				'fa fa-check-square',
				'fa fa-pencil-square',
				'fa fa-external-link-square',
				'fa fa-share-square',
				'fa fa-compass',
				'fa fa-caret-square-o-down',
				'fa fa-caret-square-o-up',
				'fa fa-caret-square-o-right',
				'fa fa-eur',
				'fa fa-gbp',
				'fa fa-usd',
				'fa fa-inr',
				'fa fa-jpy',
				'fa fa-rub',
				'fa fa-krw',
				'fa fa-btc',
				'fa fa-file',
				'fa fa-file-text',
				'fa fa-sort-alpha-asc',
				'fa fa-sort-alpha-desc',
				'fa fa-sort-amount-asc',
				'fa fa-sort-amount-desc',
				'fa fa-sort-numeric-asc',
				'fa fa-sort-numeric-desc',
				'fa fa-thumbs-up',
				'fa fa-thumbs-down',
				'fa fa-youtube-square',
				'fa fa-youtube',
				'fa fa-xing',
				'fa fa-xing-square',
				'fa fa-youtube-play',
				'fa fa-dropbox',
				'fa fa-stack-overflow',
				'fa fa-instagram',
				'fa fa-flickr',
				'fa fa-adn',
				'fa fa-bitbucket',
				'fa fa-bitbucket-square',
				'fa fa-tumblr',
				'fa fa-tumblr-square',
				'fa fa-long-arrow-down',
				'fa fa-long-arrow-up',
				'fa fa-long-arrow-left',
				'fa fa-long-arrow-right',
				'fa fa-apple',
				'fa fa-windows',
				'fa fa-android',
				'fa fa-linux',
				'fa fa-dribbble',
				'fa fa-skype',
				'fa fa-foursquare',
				'fa fa-trello',
				'fa fa-female',
				'fa fa-male',
				'fa fa-gratipay',
				'fa fa-sun-o',
				'fa fa-moon-o',
				'fa fa-archive',
				'fa fa-bug',
				'fa fa-vk',
				'fa fa-weibo',
				'fa fa-renren',
				'fa fa-pagelines',
				'fa fa-stack-exchange',
				'fa fa-arrow-circle-o-right',
				'fa fa-arrow-circle-o-left',
				'fa fa-caret-square-o-left',
				'fa fa-dot-circle-o',
				'fa fa-wheelchair',
				'fa fa-vimeo-square',
				'fa fa-try',
				'fa fa-plus-square-o',
				'fa fa-space-shuttle',
				'fa fa-slack',
				'fa fa-envelope-square',
				'fa fa-wordpress',
				'fa fa-openid',
				'fa fa-university',
				'fa fa-graduation-cap',
				'fa fa-yahoo',
				'fa fa-google',
				'fa fa-reddit',
				'fa fa-reddit-square',
				'fa fa-stumbleupon-circle',
				'fa fa-stumbleupon',
				'fa fa-delicious',
				'fa fa-digg',
				'fa fa-pied-piper-pp',
				'fa fa-pied-piper-alt',
				'fa fa-drupal',
				'fa fa-joomla',
				'fa fa-language',
				'fa fa-fax',
				'fa fa-building',
				'fa fa-child',
				'fa fa-paw',
				'fa fa-spoon',
				'fa fa-cube',
				'fa fa-cubes',
				'fa fa-behance',
				'fa fa-behance-square',
				'fa fa-steam',
				'fa fa-steam-square',
				'fa fa-recycle',
				'fa fa-car',
				'fa fa-taxi',
				'fa fa-tree',
				'fa fa-spotify',
				'fa fa-deviantart',
				'fa fa-soundcloud',
				'fa fa-database',
				'fa fa-file-pdf-o',
				'fa fa-file-word-o',
				'fa fa-file-excel-o',
				'fa fa-file-powerpoint-o',
				'fa fa-file-image-o',
				'fa fa-file-archive-o',
				'fa fa-file-audio-o',
				'fa fa-file-video-o',
				'fa fa-file-code-o',
				'fa fa-vine',
				'fa fa-codepen',
				'fa fa-jsfiddle',
				'fa fa-life-ring',
				'fa fa-circle-o-notch',
				'fa fa-rebel',
				'fa fa-empire',
				'fa fa-git-square',
				'fa fa-git',
				'fa fa-hacker-news',
				'fa fa-tencent-weibo',
				'fa fa-qq',
				'fa fa-weixin',
				'fa fa-paper-plane',
				'fa fa-paper-plane-o',
				'fa fa-history',
				'fa fa-circle-thin',
				'fa fa-header',
				'fa fa-paragraph',
				'fa fa-sliders',
				'fa fa-share-alt',
				'fa fa-share-alt-square',
				'fa fa-bomb',
				'fa fa-futbol-o',
				'fa fa-tty',
				'fa fa-binoculars',
				'fa fa-plug',
				'fa fa-slideshare',
				'fa fa-twitch',
				'fa fa-yelp',
				'fa fa-newspaper-o',
				'fa fa-wifi',
				'fa fa-calculator',
				'fa fa-paypal',
				'fa fa-google-wallet',
				'fa fa-cc-visa',
				'fa fa-cc-mastercard',
				'fa fa-cc-discover',
				'fa fa-cc-amex',
				'fa fa-cc-paypal',
				'fa fa-cc-stripe',
				'fa fa-bell-slash',
				'fa fa-bell-slash-o',
				'fa fa-trash',
				'fa fa-copyright',
				'fa fa-at',
				'fa fa-eyedropper',
				'fa fa-paint-brush',
				'fa fa-birthday-cake',
				'fa fa-area-chart',
				'fa fa-pie-chart',
				'fa fa-line-chart',
				'fa fa-lastfm',
				'fa fa-lastfm-square',
				'fa fa-toggle-off',
				'fa fa-toggle-on',
				'fa fa-bicycle',
				'fa fa-bus',
				'fa fa-ioxhost',
				'fa fa-angellist',
				'fa fa-cc',
				'fa fa-ils',
				'fa fa-meanpath',
				'fa fa-buysellads',
				'fa fa-connectdevelop',
				'fa fa-dashcube',
				'fa fa-forumbee',
				'fa fa-leanpub',
				'fa fa-sellsy',
				'fa fa-shirtsinbulk',
				'fa fa-simplybuilt',
				'fa fa-skyatlas',
				'fa fa-cart-plus',
				'fa fa-cart-arrow-down',
				'fa fa-diamond',
				'fa fa-ship',
				'fa fa-user-secret',
				'fa fa-motorcycle',
				'fa fa-street-view',
				'fa fa-heartbeat',
				'fa fa-venus',
				'fa fa-mars',
				'fa fa-mercury',
				'fa fa-transgender',
				'fa fa-transgender-alt',
				'fa fa-venus-double',
				'fa fa-mars-double',
				'fa fa-venus-mars',
				'fa fa-mars-stroke',
				'fa fa-mars-stroke-v',
				'fa fa-mars-stroke-h',
				'fa fa-neuter',
				'fa fa-genderless',
				'fa fa-facebook-official',
				'fa fa-pinterest-p',
				'fa fa-whatsapp',
				'fa fa-server',
				'fa fa-user-plus',
				'fa fa-user-times',
				'fa fa-bed',
				'fa fa-viacoin',
				'fa fa-train',
				'fa fa-subway',
				'fa fa-medium',
				'fa fa-y-combinator',
				'fa fa-optin-monster',
				'fa fa-opencart',
				'fa fa-expeditedssl',
				'fa fa-battery-full',
				'fa fa-battery-three-quarters',
				'fa fa-battery-half',
				'fa fa-battery-quarter',
				'fa fa-battery-empty',
				'fa fa-mouse-pointer',
				'fa fa-i-cursor',
				'fa fa-object-group',
				'fa fa-object-ungroup',
				'fa fa-sticky-note',
				'fa fa-sticky-note-o',
				'fa fa-cc-jcb',
				'fa fa-cc-diners-club',
				'fa fa-clone',
				'fa fa-balance-scale',
				'fa fa-hourglass-o',
				'fa fa-hourglass-start',
				'fa fa-hourglass-half',
				'fa fa-hourglass-end',
				'fa fa-hourglass',
				'fa fa-hand-rock-o',
				'fa fa-hand-paper-o',
				'fa fa-hand-scissors-o',
				'fa fa-hand-lizard-o',
				'fa fa-hand-spock-o',
				'fa fa-hand-pointer-o',
				'fa fa-hand-peace-o',
				'fa fa-trademark',
				'fa fa-registered',
				'fa fa-creative-commons',
				'fa fa-gg',
				'fa fa-gg-circle',
				'fa fa-tripadvisor',
				'fa fa-odnoklassniki',
				'fa fa-odnoklassniki-square',
				'fa fa-get-pocket',
				'fa fa-wikipedia-w',
				'fa fa-safari',
				'fa fa-chrome',
				'fa fa-firefox',
				'fa fa-opera',
				'fa fa-internet-explorer',
				'fa fa-television',
				'fa fa-contao',
				'fa fa-500px',
				'fa fa-amazon',
				'fa fa-calendar-plus-o',
				'fa fa-calendar-minus-o',
				'fa fa-calendar-times-o',
				'fa fa-calendar-check-o',
				'fa fa-industry',
				'fa fa-map-pin',
				'fa fa-map-signs',
				'fa fa-map-o',
				'fa fa-map',
				'fa fa-commenting',
				'fa fa-commenting-o',
				'fa fa-houzz',
				'fa fa-vimeo',
				'fa fa-black-tie',
				'fa fa-fonticons',
				'fa fa-reddit-alien',
				'fa fa-edge',
				'fa fa-credit-card-alt',
				'fa fa-codiepie',
				'fa fa-modx',
				'fa fa-fort-awesome',
				'fa fa-usb',
				'fa fa-product-hunt',
				'fa fa-mixcloud',
				'fa fa-scribd',
				'fa fa-pause-circle',
				'fa fa-pause-circle-o',
				'fa fa-stop-circle',
				'fa fa-stop-circle-o',
				'fa fa-shopping-bag',
				'fa fa-shopping-basket',
				'fa fa-hashtag',
				'fa fa-bluetooth',
				'fa fa-bluetooth-b',
				'fa fa-percent',
				'fa fa-gitlab',
				'fa fa-wpbeginner',
				'fa fa-wpforms',
				'fa fa-envira',
				'fa fa-universal-access',
				'fa fa-wheelchair-alt',
				'fa fa-question-circle-o',
				'fa fa-blind',
				'fa fa-audio-description',
				'fa fa-volume-control-phone',
				'fa fa-braille',
				'fa fa-assistive-listening-systems',
				'fa fa-american-sign-language-interpreting',
				'fa fa-deaf',
				'fa fa-glide',
				'fa fa-glide-g',
				'fa fa-sign-language',
				'fa fa-low-vision',
				'fa fa-viadeo',
				'fa fa-viadeo-square',
				'fa fa-snapchat',
				'fa fa-snapchat-ghost',
				'fa fa-snapchat-square',
				'fa fa-pied-piper',
				'fa fa-first-order',
				'fa fa-yoast',
				'fa fa-themeisle',
				'fa fa-google-plus-official',
				'fa fa-font-awesome',
				'fa fa-handshake-o',
				'fa fa-envelope-open',
				'fa fa-envelope-open-o',
				'fa fa-linode',
				'fa fa-address-book',
				'fa fa-address-book-o',
				'fa fa-address-card',
				'fa fa-address-card-o',
				'fa fa-user-circle',
				'fa fa-user-circle-o',
				'fa fa-user-o',
				'fa fa-id-badge',
				'fa fa-id-card',
				'fa fa-id-card-o',
				'fa fa-quora',
				'fa fa-free-code-camp',
				'fa fa-telegram',
				'fa fa-thermometer-full',
				'fa fa-thermometer-three-quarters',
				'fa fa-thermometer-half',
				'fa fa-thermometer-quarter',
				'fa fa-thermometer-empty',
				'fa fa-shower',
				'fa fa-bath',
				'fa fa-podcast',
				'fa fa-window-maximize',
				'fa fa-window-minimize',
				'fa fa-window-restore',
				'fa fa-window-close',
				'fa fa-window-close-o',
				'fa fa-bandcamp',
				'fa fa-grav',
				'fa fa-etsy',
				'fa fa-imdb',
				'fa fa-ravelry',
				'fa fa-eercast',
				'fa fa-microchip',
				'fa fa-snowflake-o',
				'fa fa-superpowers',
				'fa fa-wpexplorer',
				'fa fa-meetup'
			);

			return $icons;
		}

		public function fontawesome_five_icons() {
			$icons = array(
				'fab fa-500px',
				'fab fa-accessible-icon',
				'fab fa-accusoft',
				'fab fa-acquisitions-incorporated',
				'fas fa-ad',
				'fas fa-address-book',
				'far fa-address-book',
				'fas fa-address-card',
				'far fa-address-card',
				'fas fa-adjust',
				'fab fa-adn',
				'fab fa-adversal',
				'fab fa-affiliatetheme',
				'fas fa-air-freshener',
				'fab fa-airbnb',
				'fab fa-algolia',
				'fas fa-align-center',
				'fas fa-align-justify',
				'fas fa-align-left',
				'fas fa-align-right',
				'fab fa-alipay',
				'fas fa-allergies',
				'fab fa-amazon',
				'fab fa-amazon-pay',
				'fas fa-ambulance',
				'fas fa-american-sign-language-interpreting',
				'fab fa-amilia',
				'fas fa-anchor',
				'fab fa-android',
				'fab fa-angellist',
				'fas fa-angle-double-down',
				'fas fa-angle-double-left',
				'fas fa-angle-double-right',
				'fas fa-angle-double-up',
				'fas fa-angle-down',
				'fas fa-angle-left',
				'fas fa-angle-right',
				'fas fa-angle-up',
				'fas fa-angry',
				'far fa-angry',
				'fab fa-angrycreative',
				'fab fa-angular',
				'fas fa-ankh',
				'fab fa-app-store',
				'fab fa-app-store-ios',
				'fab fa-apper',
				'fab fa-apple',
				'fas fa-apple-alt',
				'fab fa-apple-pay',
				'fas fa-archive',
				'fas fa-archway',
				'fas fa-arrow-alt-circle-down',
				'far fa-arrow-alt-circle-down',
				'fas fa-arrow-alt-circle-left',
				'far fa-arrow-alt-circle-left',
				'fas fa-arrow-alt-circle-right',
				'far fa-arrow-alt-circle-right',
				'fas fa-arrow-alt-circle-up',
				'far fa-arrow-alt-circle-up',
				'fas fa-arrow-circle-down',
				'fas fa-arrow-circle-left',
				'fas fa-arrow-circle-right',
				'fas fa-arrow-circle-up',
				'fas fa-arrow-down',
				'fas fa-arrow-left',
				'fas fa-arrow-right',
				'fas fa-arrow-up',
				'fas fa-arrows-alt',
				'fas fa-arrows-alt-h',
				'fas fa-arrows-alt-v',
				'fab fa-artstation',
				'fas fa-assistive-listening-systems',
				'fas fa-asterisk',
				'fab fa-asymmetrik',
				'fas fa-at',
				'fas fa-atlas',
				'fab fa-atlassian',
				'fas fa-atom',
				'fab fa-audible',
				'fas fa-audio-description',
				'fab fa-autoprefixer',
				'fab fa-avianex',
				'fab fa-aviato',
				'fas fa-award',
				'fab fa-aws',
				'fas fa-baby',
				'fas fa-baby-carriage',
				'fas fa-backspace',
				'fas fa-backward',
				'fas fa-bacon',
				'fas fa-bacteria',
				'fas fa-bacterium',
				'fas fa-bahai',
				'fas fa-balance-scale',
				'fas fa-balance-scale-left',
				'fas fa-balance-scale-right',
				'fas fa-ban',
				'fas fa-band-aid',
				'fab fa-bandcamp',
				'fas fa-barcode',
				'fas fa-bars',
				'fas fa-baseball-ball',
				'fas fa-basketball-ball',
				'fas fa-bath',
				'fas fa-battery-empty',
				'fas fa-battery-full',
				'fas fa-battery-half',
				'fas fa-battery-quarter',
				'fas fa-battery-three-quarters',
				'fab fa-battle-net',
				'fas fa-bed',
				'fas fa-beer',
				'fab fa-behance',
				'fab fa-behance-square',
				'fas fa-bell',
				'far fa-bell',
				'fas fa-bell-slash',
				'far fa-bell-slash',
				'fas fa-bezier-curve',
				'fas fa-bible',
				'fas fa-bicycle',
				'fas fa-biking',
				'fab fa-bimobject',
				'fas fa-binoculars',
				'fas fa-biohazard',
				'fas fa-birthday-cake',
				'fab fa-bitbucket',
				'fab fa-bitcoin',
				'fab fa-bity',
				'fab fa-black-tie',
				'fab fa-blackberry',
				'fas fa-blender',
				'fas fa-blender-phone',
				'fas fa-blind',
				'fas fa-blog',
				'fab fa-blogger',
				'fab fa-blogger-b',
				'fab fa-bluetooth',
				'fab fa-bluetooth-b',
				'fas fa-bold',
				'fas fa-bolt',
				'fas fa-bomb',
				'fas fa-bone',
				'fas fa-bong',
				'fas fa-book',
				'fas fa-book-dead',
				'fas fa-book-medical',
				'fas fa-book-open',
				'fas fa-book-reader',
				'fas fa-bookmark',
				'far fa-bookmark',
				'fab fa-bootstrap',
				'fas fa-border-all',
				'fas fa-border-none',
				'fas fa-border-style',
				'fas fa-bowling-ball',
				'fas fa-box',
				'fas fa-box-open',
				'fas fa-box-tissue',
				'fas fa-boxes',
				'fas fa-braille',
				'fas fa-brain',
				'fas fa-bread-slice',
				'fas fa-briefcase',
				'fas fa-briefcase-medical',
				'fas fa-broadcast-tower',
				'fas fa-broom',
				'fas fa-brush',
				'fab fa-btc',
				'fab fa-buffer',
				'fas fa-bug',
				'fas fa-building',
				'far fa-building',
				'fas fa-bullhorn',
				'fas fa-bullseye',
				'fas fa-burn',
				'fab fa-buromobelexperte',
				'fas fa-bus',
				'fas fa-bus-alt',
				'fas fa-business-time',
				'fab fa-buy-n-large',
				'fab fa-buysellads',
				'fas fa-calculator',
				'fas fa-calendar',
				'far fa-calendar',
				'fas fa-calendar-alt',
				'far fa-calendar-alt',
				'fas fa-calendar-check',
				'far fa-calendar-check',
				'fas fa-calendar-day',
				'fas fa-calendar-minus',
				'far fa-calendar-minus',
				'fas fa-calendar-plus',
				'far fa-calendar-plus',
				'fas fa-calendar-times',
				'far fa-calendar-times',
				'fas fa-calendar-week',
				'fas fa-camera',
				'fas fa-camera-retro',
				'fas fa-campground',
				'fab fa-canadian-maple-leaf',
				'fas fa-candy-cane',
				'fas fa-cannabis',
				'fas fa-capsules',
				'fas fa-car',
				'fas fa-car-alt',
				'fas fa-car-battery',
				'fas fa-car-crash',
				'fas fa-car-side',
				'fas fa-caravan',
				'fas fa-caret-down',
				'fas fa-caret-left',
				'fas fa-caret-right',
				'fas fa-caret-square-down',
				'far fa-caret-square-down',
				'fas fa-caret-square-left',
				'far fa-caret-square-left',
				'fas fa-caret-square-right',
				'far fa-caret-square-right',
				'fas fa-caret-square-up',
				'far fa-caret-square-up',
				'fas fa-caret-up',
				'fas fa-carrot',
				'fas fa-cart-arrow-down',
				'fas fa-cart-plus',
				'fas fa-cash-register',
				'fas fa-cat',
				'fab fa-cc-amazon-pay',
				'fab fa-cc-amex',
				'fab fa-cc-apple-pay',
				'fab fa-cc-diners-club',
				'fab fa-cc-discover',
				'fab fa-cc-jcb',
				'fab fa-cc-mastercard',
				'fab fa-cc-paypal',
				'fab fa-cc-stripe',
				'fab fa-cc-visa',
				'fab fa-centercode',
				'fab fa-centos',
				'fas fa-certificate',
				'fas fa-chair',
				'fas fa-chalkboard',
				'fas fa-chalkboard-teacher',
				'fas fa-charging-station',
				'fas fa-chart-area',
				'fas fa-chart-bar',
				'far fa-chart-bar',
				'fas fa-chart-line',
				'fas fa-chart-pie',
				'fas fa-check',
				'fas fa-check-circle',
				'far fa-check-circle',
				'fas fa-check-double',
				'fas fa-check-square',
				'far fa-check-square',
				'fas fa-cheese',
				'fas fa-chess',
				'fas fa-chess-bishop',
				'fas fa-chess-board',
				'fas fa-chess-king',
				'fas fa-chess-knight',
				'fas fa-chess-pawn',
				'fas fa-chess-queen',
				'fas fa-chess-rook',
				'fas fa-chevron-circle-down',
				'fas fa-chevron-circle-left',
				'fas fa-chevron-circle-right',
				'fas fa-chevron-circle-up',
				'fas fa-chevron-down',
				'fas fa-chevron-left',
				'fas fa-chevron-right',
				'fas fa-chevron-up',
				'fas fa-child',
				'fab fa-chrome',
				'fab fa-chromecast',
				'fas fa-church',
				'fas fa-circle',
				'far fa-circle',
				'fas fa-circle-notch',
				'fas fa-city',
				'fas fa-clinic-medical',
				'fas fa-clipboard',
				'far fa-clipboard',
				'fas fa-clipboard-check',
				'fas fa-clipboard-list',
				'fas fa-clock',
				'far fa-clock',
				'fas fa-clone',
				'far fa-clone',
				'fas fa-closed-captioning',
				'far fa-closed-captioning',
				'fas fa-cloud',
				'fas fa-cloud-download-alt',
				'fas fa-cloud-meatball',
				'fas fa-cloud-moon',
				'fas fa-cloud-moon-rain',
				'fas fa-cloud-rain',
				'fas fa-cloud-showers-heavy',
				'fas fa-cloud-sun',
				'fas fa-cloud-sun-rain',
				'fas fa-cloud-upload-alt',
				'fab fa-cloudflare',
				'fab fa-cloudscale',
				'fab fa-cloudsmith',
				'fab fa-cloudversify',
				'fas fa-cocktail',
				'fas fa-code',
				'fas fa-code-branch',
				'fab fa-codepen',
				'fab fa-codiepie',
				'fas fa-coffee',
				'fas fa-cog',
				'fas fa-cogs',
				'fas fa-coins',
				'fas fa-columns',
				'fas fa-comment',
				'far fa-comment',
				'fas fa-comment-alt',
				'far fa-comment-alt',
				'fas fa-comment-dollar',
				'fas fa-comment-dots',
				'far fa-comment-dots',
				'fas fa-comment-medical',
				'fas fa-comment-slash',
				'fas fa-comments',
				'far fa-comments',
				'fas fa-comments-dollar',
				'fas fa-compact-disc',
				'fas fa-compass',
				'far fa-compass',
				'fas fa-compress',
				'fas fa-compress-alt',
				'fas fa-compress-arrows-alt',
				'fas fa-concierge-bell',
				'fab fa-confluence',
				'fab fa-connectdevelop',
				'fab fa-contao',
				'fas fa-cookie',
				'fas fa-cookie-bite',
				'fas fa-copy',
				'far fa-copy',
				'fas fa-copyright',
				'far fa-copyright',
				'fab fa-cotton-bureau',
				'fas fa-couch',
				'fab fa-cpanel',
				'fab fa-creative-commons',
				'fab fa-creative-commons-by',
				'fab fa-creative-commons-nc',
				'fab fa-creative-commons-nc-eu',
				'fab fa-creative-commons-nc-jp',
				'fab fa-creative-commons-nd',
				'fab fa-creative-commons-pd',
				'fab fa-creative-commons-pd-alt',
				'fab fa-creative-commons-remix',
				'fab fa-creative-commons-sa',
				'fab fa-creative-commons-sampling',
				'fab fa-creative-commons-sampling-plus',
				'fab fa-creative-commons-share',
				'fab fa-creative-commons-zero',
				'fas fa-credit-card',
				'far fa-credit-card',
				'fab fa-critical-role',
				'fas fa-crop',
				'fas fa-crop-alt',
				'fas fa-cross',
				'fas fa-crosshairs',
				'fas fa-crow',
				'fas fa-crown',
				'fas fa-crutch',
				'fab fa-css3',
				'fab fa-css3-alt',
				'fas fa-cube',
				'fas fa-cubes',
				'fas fa-cut',
				'fab fa-cuttlefish',
				'fab fa-d-and-d',
				'fab fa-d-and-d-beyond',
				'fab fa-dailymotion',
				'fab fa-dashcube',
				'fas fa-database',
				'fas fa-deaf',
				'fab fa-deezer',
				'fab fa-delicious',
				'fas fa-democrat',
				'fab fa-deploydog',
				'fab fa-deskpro',
				'fas fa-desktop',
				'fab fa-dev',
				'fab fa-deviantart',
				'fas fa-dharmachakra',
				'fab fa-dhl',
				'fas fa-diagnoses',
				'fab fa-diaspora',
				'fas fa-dice',
				'fas fa-dice-d20',
				'fas fa-dice-d6',
				'fas fa-dice-five',
				'fas fa-dice-four',
				'fas fa-dice-one',
				'fas fa-dice-six',
				'fas fa-dice-three',
				'fas fa-dice-two',
				'fab fa-digg',
				'fab fa-digital-ocean',
				'fas fa-digital-tachograph',
				'fas fa-directions',
				'fab fa-discord',
				'fab fa-discourse',
				'fas fa-disease',
				'fas fa-divide',
				'fas fa-dizzy',
				'far fa-dizzy',
				'fas fa-dna',
				'fab fa-dochub',
				'fab fa-docker',
				'fas fa-dog',
				'fas fa-dollar-sign',
				'fas fa-dolly',
				'fas fa-dolly-flatbed',
				'fas fa-donate',
				'fas fa-door-closed',
				'fas fa-door-open',
				'fas fa-dot-circle',
				'far fa-dot-circle',
				'fas fa-dove',
				'fas fa-download',
				'fab fa-draft2digital',
				'fas fa-drafting-compass',
				'fas fa-dragon',
				'fas fa-draw-polygon',
				'fab fa-dribbble',
				'fab fa-dribbble-square',
				'fab fa-dropbox',
				'fas fa-drum',
				'fas fa-drum-steelpan',
				'fas fa-drumstick-bite',
				'fab fa-drupal',
				'fas fa-dumbbell',
				'fas fa-dumpster',
				'fas fa-dumpster-fire',
				'fas fa-dungeon',
				'fab fa-dyalog',
				'fab fa-earlybirds',
				'fab fa-ebay',
				'fab fa-edge',
				'fab fa-edge-legacy',
				'fas fa-edit',
				'far fa-edit',
				'fas fa-egg',
				'fas fa-eject',
				'fab fa-elementor',
				'fas fa-ellipsis-h',
				'fas fa-ellipsis-v',
				'fab fa-ello',
				'fab fa-ember',
				'fab fa-empire',
				'fas fa-envelope',
				'far fa-envelope',
				'fas fa-envelope-open',
				'far fa-envelope-open',
				'fas fa-envelope-open-text',
				'fas fa-envelope-square',
				'fab fa-envira',
				'fas fa-equals',
				'fas fa-eraser',
				'fab fa-erlang',
				'fab fa-ethereum',
				'fas fa-ethernet',
				'fab fa-etsy',
				'fas fa-euro-sign',
				'fab fa-evernote',
				'fas fa-exchange-alt',
				'fas fa-exclamation',
				'fas fa-exclamation-circle',
				'fas fa-exclamation-triangle',
				'fas fa-expand',
				'fas fa-expand-alt',
				'fas fa-expand-arrows-alt',
				'fab fa-expeditedssl',
				'fas fa-external-link-alt',
				'fas fa-external-link-square-alt',
				'fas fa-eye',
				'far fa-eye',
				'fas fa-eye-dropper',
				'fas fa-eye-slash',
				'far fa-eye-slash',
				'fab fa-facebook',
				'fab fa-facebook-f',
				'fab fa-facebook-messenger',
				'fab fa-facebook-square',
				'fas fa-fan',
				'fab fa-fantasy-flight-games',
				'fas fa-fast-backward',
				'fas fa-fast-forward',
				'fas fa-faucet',
				'fas fa-fax',
				'fas fa-feather',
				'fas fa-feather-alt',
				'fab fa-fedex',
				'fab fa-fedora',
				'fas fa-female',
				'fas fa-fighter-jet',
				'fab fa-figma',
				'fas fa-file',
				'far fa-file',
				'fas fa-file-alt',
				'far fa-file-alt',
				'fas fa-file-archive',
				'far fa-file-archive',
				'fas fa-file-audio',
				'far fa-file-audio',
				'fas fa-file-code',
				'far fa-file-code',
				'fas fa-file-contract',
				'fas fa-file-csv',
				'fas fa-file-download',
				'fas fa-file-excel',
				'far fa-file-excel',
				'fas fa-file-export',
				'fas fa-file-image',
				'far fa-file-image',
				'fas fa-file-import',
				'fas fa-file-invoice',
				'fas fa-file-invoice-dollar',
				'fas fa-file-medical',
				'fas fa-file-medical-alt',
				'fas fa-file-pdf',
				'far fa-file-pdf',
				'fas fa-file-powerpoint',
				'far fa-file-powerpoint',
				'fas fa-file-prescription',
				'fas fa-file-signature',
				'fas fa-file-upload',
				'fas fa-file-video',
				'far fa-file-video',
				'fas fa-file-word',
				'far fa-file-word',
				'fas fa-fill',
				'fas fa-fill-drip',
				'fas fa-film',
				'fas fa-filter',
				'fas fa-fingerprint',
				'fas fa-fire',
				'fas fa-fire-alt',
				'fas fa-fire-extinguisher',
				'fab fa-firefox',
				'fab fa-firefox-browser',
				'fas fa-first-aid',
				'fab fa-first-order',
				'fab fa-first-order-alt',
				'fab fa-firstdraft',
				'fas fa-fish',
				'fas fa-fist-raised',
				'fas fa-flag',
				'far fa-flag',
				'fas fa-flag-checkered',
				'fas fa-flag-usa',
				'fas fa-flask',
				'fab fa-flickr',
				'fab fa-flipboard',
				'fas fa-flushed',
				'far fa-flushed',
				'fab fa-fly',
				'fas fa-folder',
				'far fa-folder',
				'fas fa-folder-minus',
				'fas fa-folder-open',
				'far fa-folder-open',
				'fas fa-folder-plus',
				'fas fa-font',
				'fab fa-font-awesome',
				'fab fa-font-awesome-alt',
				'fab fa-font-awesome-flag',
				'far fa-font-awesome-logo-full',
				'fas fa-font-awesome-logo-full',
				'fab fa-font-awesome-logo-full',
				'fab fa-fonticons',
				'fab fa-fonticons-fi',
				'fas fa-football-ball',
				'fab fa-fort-awesome',
				'fab fa-fort-awesome-alt',
				'fab fa-forumbee',
				'fas fa-forward',
				'fab fa-foursquare',
				'fab fa-free-code-camp',
				'fab fa-freebsd',
				'fas fa-frog',
				'fas fa-frown',
				'far fa-frown',
				'fas fa-frown-open',
				'far fa-frown-open',
				'fab fa-fulcrum',
				'fas fa-funnel-dollar',
				'fas fa-futbol',
				'far fa-futbol',
				'fab fa-galactic-republic',
				'fab fa-galactic-senate',
				'fas fa-gamepad',
				'fas fa-gas-pump',
				'fas fa-gavel',
				'fas fa-gem',
				'far fa-gem',
				'fas fa-genderless',
				'fab fa-get-pocket',
				'fab fa-gg',
				'fab fa-gg-circle',
				'fas fa-ghost',
				'fas fa-gift',
				'fas fa-gifts',
				'fab fa-git',
				'fab fa-git-alt',
				'fab fa-git-square',
				'fab fa-github',
				'fab fa-github-alt',
				'fab fa-github-square',
				'fab fa-gitkraken',
				'fab fa-gitlab',
				'fab fa-gitter',
				'fas fa-glass-cheers',
				'fas fa-glass-martini',
				'fas fa-glass-martini-alt',
				'fas fa-glass-whiskey',
				'fas fa-glasses',
				'fab fa-glide',
				'fab fa-glide-g',
				'fas fa-globe',
				'fas fa-globe-africa',
				'fas fa-globe-americas',
				'fas fa-globe-asia',
				'fas fa-globe-europe',
				'fab fa-gofore',
				'fas fa-golf-ball',
				'fab fa-goodreads',
				'fab fa-goodreads-g',
				'fab fa-google',
				'fab fa-google-drive',
				'fab fa-google-pay',
				'fab fa-google-play',
				'fab fa-google-plus',
				'fab fa-google-plus-g',
				'fab fa-google-plus-square',
				'fab fa-google-wallet',
				'fas fa-gopuram',
				'fas fa-graduation-cap',
				'fab fa-gratipay',
				'fab fa-grav',
				'fas fa-greater-than',
				'fas fa-greater-than-equal',
				'fas fa-grimace',
				'far fa-grimace',
				'fas fa-grin',
				'far fa-grin',
				'fas fa-grin-alt',
				'far fa-grin-alt',
				'fas fa-grin-beam',
				'far fa-grin-beam',
				'fas fa-grin-beam-sweat',
				'far fa-grin-beam-sweat',
				'fas fa-grin-hearts',
				'far fa-grin-hearts',
				'fas fa-grin-squint',
				'far fa-grin-squint',
				'fas fa-grin-squint-tears',
				'far fa-grin-squint-tears',
				'fas fa-grin-stars',
				'far fa-grin-stars',
				'fas fa-grin-tears',
				'far fa-grin-tears',
				'fas fa-grin-tongue',
				'far fa-grin-tongue',
				'fas fa-grin-tongue-squint',
				'far fa-grin-tongue-squint',
				'fas fa-grin-tongue-wink',
				'far fa-grin-tongue-wink',
				'fas fa-grin-wink',
				'far fa-grin-wink',
				'fas fa-grip-horizontal',
				'fas fa-grip-lines',
				'fas fa-grip-lines-vertical',
				'fas fa-grip-vertical',
				'fab fa-gripfire',
				'fab fa-grunt',
				'fab fa-guilded',
				'fas fa-guitar',
				'fab fa-gulp',
				'fas fa-h-square',
				'fab fa-hacker-news',
				'fab fa-hacker-news-square',
				'fab fa-hackerrank',
				'fas fa-hamburger',
				'fas fa-hammer',
				'fas fa-hamsa',
				'fas fa-hand-holding',
				'fas fa-hand-holding-heart',
				'fas fa-hand-holding-medical',
				'fas fa-hand-holding-usd',
				'fas fa-hand-holding-water',
				'fas fa-hand-lizard',
				'far fa-hand-lizard',
				'fas fa-hand-middle-finger',
				'fas fa-hand-paper',
				'far fa-hand-paper',
				'fas fa-hand-peace',
				'far fa-hand-peace',
				'fas fa-hand-point-down',
				'far fa-hand-point-down',
				'fas fa-hand-point-left',
				'far fa-hand-point-left',
				'fas fa-hand-point-right',
				'far fa-hand-point-right',
				'fas fa-hand-point-up',
				'far fa-hand-point-up',
				'fas fa-hand-pointer',
				'far fa-hand-pointer',
				'fas fa-hand-rock',
				'far fa-hand-rock',
				'fas fa-hand-scissors',
				'far fa-hand-scissors',
				'fas fa-hand-sparkles',
				'fas fa-hand-spock',
				'far fa-hand-spock',
				'fas fa-hands',
				'fas fa-hands-helping',
				'fas fa-hands-wash',
				'fas fa-handshake',
				'far fa-handshake',
				'fas fa-handshake-alt-slash',
				'fas fa-handshake-slash',
				'fas fa-hanukiah',
				'fas fa-hard-hat',
				'fas fa-hashtag',
				'fas fa-hat-cowboy',
				'fas fa-hat-cowboy-side',
				'fas fa-hat-wizard',
				'fas fa-hdd',
				'far fa-hdd',
				'fas fa-head-side-cough',
				'fas fa-head-side-cough-slash',
				'fas fa-head-side-mask',
				'fas fa-head-side-virus',
				'fas fa-heading',
				'fas fa-headphones',
				'fas fa-headphones-alt',
				'fas fa-headset',
				'fas fa-heart',
				'far fa-heart',
				'fas fa-heart-broken',
				'fas fa-heartbeat',
				'fas fa-helicopter',
				'fas fa-highlighter',
				'fas fa-hiking',
				'fas fa-hippo',
				'fab fa-hips',
				'fab fa-hire-a-helper',
				'fas fa-history',
				'fab fa-hive',
				'fas fa-hockey-puck',
				'fas fa-holly-berry',
				'fas fa-home',
				'fab fa-hooli',
				'fab fa-hornbill',
				'fas fa-horse',
				'fas fa-horse-head',
				'fas fa-hospital',
				'far fa-hospital',
				'fas fa-hospital-alt',
				'fas fa-hospital-symbol',
				'fas fa-hospital-user',
				'fas fa-hot-tub',
				'fas fa-hotdog',
				'fas fa-hotel',
				'fab fa-hotjar',
				'fas fa-hourglass',
				'far fa-hourglass',
				'fas fa-hourglass-end',
				'fas fa-hourglass-half',
				'fas fa-hourglass-start',
				'fas fa-house-damage',
				'fas fa-house-user',
				'fab fa-houzz',
				'fas fa-hryvnia',
				'fab fa-html5',
				'fab fa-hubspot',
				'fas fa-i-cursor',
				'fas fa-ice-cream',
				'fas fa-icicles',
				'fas fa-icons',
				'fas fa-id-badge',
				'far fa-id-badge',
				'fas fa-id-card',
				'far fa-id-card',
				'fas fa-id-card-alt',
				'fab fa-ideal',
				'fas fa-igloo',
				'fas fa-image',
				'far fa-image',
				'fas fa-images',
				'far fa-images',
				'fab fa-imdb',
				'fas fa-inbox',
				'fas fa-indent',
				'fas fa-industry',
				'fas fa-infinity',
				'fas fa-info',
				'fas fa-info-circle',
				'fab fa-innosoft',
				'fab fa-instagram',
				'fab fa-instagram-square',
				'fab fa-instalod',
				'fab fa-intercom',
				'fab fa-internet-explorer',
				'fab fa-invision',
				'fab fa-ioxhost',
				'fas fa-italic',
				'fab fa-itch-io',
				'fab fa-itunes',
				'fab fa-itunes-note',
				'fab fa-java',
				'fas fa-jedi',
				'fab fa-jedi-order',
				'fab fa-jenkins',
				'fab fa-jira',
				'fab fa-joget',
				'fas fa-joint',
				'fab fa-joomla',
				'fas fa-journal-whills',
				'fab fa-js',
				'fab fa-js-square',
				'fab fa-jsfiddle',
				'fas fa-kaaba',
				'fab fa-kaggle',
				'fas fa-key',
				'fab fa-keybase',
				'fas fa-keyboard',
				'far fa-keyboard',
				'fab fa-keycdn',
				'fas fa-khanda',
				'fab fa-kickstarter',
				'fab fa-kickstarter-k',
				'fas fa-kiss',
				'far fa-kiss',
				'fas fa-kiss-beam',
				'far fa-kiss-beam',
				'fas fa-kiss-wink-heart',
				'far fa-kiss-wink-heart',
				'fas fa-kiwi-bird',
				'fab fa-korvue',
				'fas fa-landmark',
				'fas fa-language',
				'fas fa-laptop',
				'fas fa-laptop-code',
				'fas fa-laptop-house',
				'fas fa-laptop-medical',
				'fab fa-laravel',
				'fab fa-lastfm',
				'fab fa-lastfm-square',
				'fas fa-laugh',
				'far fa-laugh',
				'fas fa-laugh-beam',
				'far fa-laugh-beam',
				'fas fa-laugh-squint',
				'far fa-laugh-squint',
				'fas fa-laugh-wink',
				'far fa-laugh-wink',
				'fas fa-layer-group',
				'fas fa-leaf',
				'fab fa-leanpub',
				'fas fa-lemon',
				'far fa-lemon',
				'fab fa-less',
				'fas fa-less-than',
				'fas fa-less-than-equal',
				'fas fa-level-down-alt',
				'fas fa-level-up-alt',
				'fas fa-life-ring',
				'far fa-life-ring',
				'fas fa-lightbulb',
				'far fa-lightbulb',
				'fab fa-line',
				'fas fa-link',
				'fab fa-linkedin',
				'fab fa-linkedin-in',
				'fab fa-linode',
				'fab fa-linux',
				'fas fa-lira-sign',
				'fas fa-list',
				'fas fa-list-alt',
				'far fa-list-alt',
				'fas fa-list-ol',
				'fas fa-list-ul',
				'fas fa-location-arrow',
				'fas fa-lock',
				'fas fa-lock-open',
				'fas fa-long-arrow-alt-down',
				'fas fa-long-arrow-alt-left',
				'fas fa-long-arrow-alt-right',
				'fas fa-long-arrow-alt-up',
				'fas fa-low-vision',
				'fas fa-luggage-cart',
				'fas fa-lungs',
				'fas fa-lungs-virus',
				'fab fa-lyft',
				'fab fa-magento',
				'fas fa-magic',
				'fas fa-magnet',
				'fas fa-mail-bulk',
				'fab fa-mailchimp',
				'fas fa-male',
				'fab fa-mandalorian',
				'fas fa-map',
				'far fa-map',
				'fas fa-map-marked',
				'fas fa-map-marked-alt',
				'fas fa-map-marker',
				'fas fa-map-marker-alt',
				'fas fa-map-pin',
				'fas fa-map-signs',
				'fab fa-markdown',
				'fas fa-marker',
				'fas fa-mars',
				'fas fa-mars-double',
				'fas fa-mars-stroke',
				'fas fa-mars-stroke-h',
				'fas fa-mars-stroke-v',
				'fas fa-mask',
				'fab fa-mastodon',
				'fab fa-maxcdn',
				'fab fa-mdb',
				'fas fa-medal',
				'fab fa-medapps',
				'fab fa-medium',
				'fab fa-medium-m',
				'fas fa-medkit',
				'fab fa-medrt',
				'fab fa-meetup',
				'fab fa-megaport',
				'fas fa-meh',
				'far fa-meh',
				'fas fa-meh-blank',
				'far fa-meh-blank',
				'fas fa-meh-rolling-eyes',
				'far fa-meh-rolling-eyes',
				'fas fa-memory',
				'fab fa-mendeley',
				'fas fa-menorah',
				'fas fa-mercury',
				'fas fa-meteor',
				'fab fa-microblog',
				'fas fa-microchip',
				'fas fa-microphone',
				'fas fa-microphone-alt',
				'fas fa-microphone-alt-slash',
				'fas fa-microphone-slash',
				'fas fa-microscope',
				'fab fa-microsoft',
				'fas fa-minus',
				'fas fa-minus-circle',
				'fas fa-minus-square',
				'far fa-minus-square',
				'fas fa-mitten',
				'fab fa-mix',
				'fab fa-mixcloud',
				'fab fa-mixer',
				'fab fa-mizuni',
				'fas fa-mobile',
				'fas fa-mobile-alt',
				'fab fa-modx',
				'fab fa-monero',
				'fas fa-money-bill',
				'fas fa-money-bill-alt',
				'far fa-money-bill-alt',
				'fas fa-money-bill-wave',
				'fas fa-money-bill-wave-alt',
				'fas fa-money-check',
				'fas fa-money-check-alt',
				'fas fa-monument',
				'fas fa-moon',
				'far fa-moon',
				'fas fa-mortar-pestle',
				'fas fa-mosque',
				'fas fa-motorcycle',
				'fas fa-mountain',
				'fas fa-mouse',
				'fas fa-mouse-pointer',
				'fas fa-mug-hot',
				'fas fa-music',
				'fab fa-napster',
				'fab fa-neos',
				'fas fa-network-wired',
				'fas fa-neuter',
				'fas fa-newspaper',
				'far fa-newspaper',
				'fab fa-nimblr',
				'fab fa-node',
				'fab fa-node-js',
				'fas fa-not-equal',
				'fas fa-notes-medical',
				'fab fa-npm',
				'fab fa-ns8',
				'fab fa-nutritionix',
				'fas fa-object-group',
				'far fa-object-group',
				'fas fa-object-ungroup',
				'far fa-object-ungroup',
				'fab fa-octopus-deploy',
				'fab fa-odnoklassniki',
				'fab fa-odnoklassniki-square',
				'fas fa-oil-can',
				'fab fa-old-republic',
				'fas fa-om',
				'fab fa-opencart',
				'fab fa-openid',
				'fab fa-opera',
				'fab fa-optin-monster',
				'fab fa-orcid',
				'fab fa-osi',
				'fas fa-otter',
				'fas fa-outdent',
				'fab fa-page4',
				'fab fa-pagelines',
				'fas fa-pager',
				'fas fa-paint-brush',
				'fas fa-paint-roller',
				'fas fa-palette',
				'fab fa-palfed',
				'fas fa-pallet',
				'fas fa-paper-plane',
				'far fa-paper-plane',
				'fas fa-paperclip',
				'fas fa-parachute-box',
				'fas fa-paragraph',
				'fas fa-parking',
				'fas fa-passport',
				'fas fa-pastafarianism',
				'fas fa-paste',
				'fab fa-patreon',
				'fas fa-pause',
				'fas fa-pause-circle',
				'far fa-pause-circle',
				'fas fa-paw',
				'fab fa-paypal',
				'fas fa-peace',
				'fas fa-pen',
				'fas fa-pen-alt',
				'fas fa-pen-fancy',
				'fas fa-pen-nib',
				'fas fa-pen-square',
				'fas fa-pencil-alt',
				'fas fa-pencil-ruler',
				'fab fa-penny-arcade',
				'fas fa-people-arrows',
				'fas fa-people-carry',
				'fas fa-pepper-hot',
				'fab fa-perbyte',
				'fas fa-percent',
				'fas fa-percentage',
				'fab fa-periscope',
				'fas fa-person-booth',
				'fab fa-phabricator',
				'fab fa-phoenix-framework',
				'fab fa-phoenix-squadron',
				'fas fa-phone',
				'fas fa-phone-alt',
				'fas fa-phone-slash',
				'fas fa-phone-square',
				'fas fa-phone-square-alt',
				'fas fa-phone-volume',
				'fas fa-photo-video',
				'fab fa-php',
				'fab fa-pied-piper',
				'fab fa-pied-piper-alt',
				'fab fa-pied-piper-hat',
				'fab fa-pied-piper-pp',
				'fab fa-pied-piper-square',
				'fas fa-piggy-bank',
				'fas fa-pills',
				'fab fa-pinterest',
				'fab fa-pinterest-p',
				'fab fa-pinterest-square',
				'fas fa-pizza-slice',
				'fas fa-place-of-worship',
				'fas fa-plane',
				'fas fa-plane-arrival',
				'fas fa-plane-departure',
				'fas fa-plane-slash',
				'fas fa-play',
				'fas fa-play-circle',
				'far fa-play-circle',
				'fab fa-playstation',
				'fas fa-plug',
				'fas fa-plus',
				'fas fa-plus-circle',
				'fas fa-plus-square',
				'far fa-plus-square',
				'fas fa-podcast',
				'fas fa-poll',
				'fas fa-poll-h',
				'fas fa-poo',
				'fas fa-poo-storm',
				'fas fa-poop',
				'fas fa-portrait',
				'fas fa-pound-sign',
				'fas fa-power-off',
				'fas fa-pray',
				'fas fa-praying-hands',
				'fas fa-prescription',
				'fas fa-prescription-bottle',
				'fas fa-prescription-bottle-alt',
				'fas fa-print',
				'fas fa-procedures',
				'fab fa-product-hunt',
				'fas fa-project-diagram',
				'fas fa-pump-medical',
				'fas fa-pump-soap',
				'fab fa-pushed',
				'fas fa-puzzle-piece',
				'fab fa-python',
				'fab fa-qq',
				'fas fa-qrcode',
				'fas fa-question',
				'fas fa-question-circle',
				'far fa-question-circle',
				'fas fa-quidditch',
				'fab fa-quinscape',
				'fab fa-quora',
				'fas fa-quote-left',
				'fas fa-quote-right',
				'fas fa-quran',
				'fab fa-r-project',
				'fas fa-radiation',
				'fas fa-radiation-alt',
				'fas fa-rainbow',
				'fas fa-random',
				'fab fa-raspberry-pi',
				'fab fa-ravelry',
				'fab fa-react',
				'fab fa-reacteurope',
				'fab fa-readme',
				'fab fa-rebel',
				'fas fa-receipt',
				'fas fa-record-vinyl',
				'fas fa-recycle',
				'fab fa-red-river',
				'fab fa-reddit',
				'fab fa-reddit-alien',
				'fab fa-reddit-square',
				'fab fa-redhat',
				'fas fa-redo',
				'fas fa-redo-alt',
				'fas fa-registered',
				'far fa-registered',
				'fas fa-remove-format',
				'fab fa-renren',
				'fas fa-reply',
				'fas fa-reply-all',
				'fab fa-replyd',
				'fas fa-republican',
				'fab fa-researchgate',
				'fab fa-resolving',
				'fas fa-restroom',
				'fas fa-retweet',
				'fab fa-rev',
				'fas fa-ribbon',
				'fas fa-ring',
				'fas fa-road',
				'fas fa-robot',
				'fas fa-rocket',
				'fab fa-rocketchat',
				'fab fa-rockrms',
				'fas fa-route',
				'fas fa-rss',
				'fas fa-rss-square',
				'fas fa-ruble-sign',
				'fas fa-ruler',
				'fas fa-ruler-combined',
				'fas fa-ruler-horizontal',
				'fas fa-ruler-vertical',
				'fas fa-running',
				'fas fa-rupee-sign',
				'fab fa-rust',
				'fas fa-sad-cry',
				'far fa-sad-cry',
				'fas fa-sad-tear',
				'far fa-sad-tear',
				'fab fa-safari',
				'fab fa-salesforce',
				'fab fa-sass',
				'fas fa-satellite',
				'fas fa-satellite-dish',
				'fas fa-save',
				'far fa-save',
				'fab fa-schlix',
				'fas fa-school',
				'fas fa-screwdriver',
				'fab fa-scribd',
				'fas fa-scroll',
				'fas fa-sd-card',
				'fas fa-search',
				'fas fa-search-dollar',
				'fas fa-search-location',
				'fas fa-search-minus',
				'fas fa-search-plus',
				'fab fa-searchengin',
				'fas fa-seedling',
				'fab fa-sellcast',
				'fab fa-sellsy',
				'fas fa-server',
				'fab fa-servicestack',
				'fas fa-shapes',
				'fas fa-share',
				'fas fa-share-alt',
				'fas fa-share-alt-square',
				'fas fa-share-square',
				'far fa-share-square',
				'fas fa-shekel-sign',
				'fas fa-shield-alt',
				'fas fa-shield-virus',
				'fas fa-ship',
				'fas fa-shipping-fast',
				'fab fa-shirtsinbulk',
				'fas fa-shoe-prints',
				'fab fa-shopify',
				'fas fa-shopping-bag',
				'fas fa-shopping-basket',
				'fas fa-shopping-cart',
				'fab fa-shopware',
				'fas fa-shower',
				'fas fa-shuttle-van',
				'fas fa-sign',
				'fas fa-sign-in-alt',
				'fas fa-sign-language',
				'fas fa-sign-out-alt',
				'fas fa-signal',
				'fas fa-signature',
				'fas fa-sim-card',
				'fab fa-simplybuilt',
				'fas fa-sink',
				'fab fa-sistrix',
				'fas fa-sitemap',
				'fab fa-sith',
				'fas fa-skating',
				'fab fa-sketch',
				'fas fa-skiing',
				'fas fa-skiing-nordic',
				'fas fa-skull',
				'fas fa-skull-crossbones',
				'fab fa-skyatlas',
				'fab fa-skype',
				'fab fa-slack',
				'fab fa-slack-hash',
				'fas fa-slash',
				'fas fa-sleigh',
				'fas fa-sliders-h',
				'fab fa-slideshare',
				'fas fa-smile',
				'far fa-smile',
				'fas fa-smile-beam',
				'far fa-smile-beam',
				'fas fa-smile-wink',
				'far fa-smile-wink',
				'fas fa-smog',
				'fas fa-smoking',
				'fas fa-smoking-ban',
				'fas fa-sms',
				'fab fa-snapchat',
				'fab fa-snapchat-ghost',
				'fab fa-snapchat-square',
				'fas fa-snowboarding',
				'fas fa-snowflake',
				'far fa-snowflake',
				'fas fa-snowman',
				'fas fa-snowplow',
				'fas fa-soap',
				'fas fa-socks',
				'fas fa-solar-panel',
				'fas fa-sort',
				'fas fa-sort-alpha-down',
				'fas fa-sort-alpha-down-alt',
				'fas fa-sort-alpha-up',
				'fas fa-sort-alpha-up-alt',
				'fas fa-sort-amount-down',
				'fas fa-sort-amount-down-alt',
				'fas fa-sort-amount-up',
				'fas fa-sort-amount-up-alt',
				'fas fa-sort-down',
				'fas fa-sort-numeric-down',
				'fas fa-sort-numeric-down-alt',
				'fas fa-sort-numeric-up',
				'fas fa-sort-numeric-up-alt',
				'fas fa-sort-up',
				'fab fa-soundcloud',
				'fab fa-sourcetree',
				'fas fa-spa',
				'fas fa-space-shuttle',
				'fab fa-speakap',
				'fab fa-speaker-deck',
				'fas fa-spell-check',
				'fas fa-spider',
				'fas fa-spinner',
				'fas fa-splotch',
				'fab fa-spotify',
				'fas fa-spray-can',
				'fas fa-square',
				'far fa-square',
				'fas fa-square-full',
				'fas fa-square-root-alt',
				'fab fa-squarespace',
				'fab fa-stack-exchange',
				'fab fa-stack-overflow',
				'fab fa-stackpath',
				'fas fa-stamp',
				'fas fa-star',
				'far fa-star',
				'fas fa-star-and-crescent',
				'fas fa-star-half',
				'far fa-star-half',
				'fas fa-star-half-alt',
				'fas fa-star-of-david',
				'fas fa-star-of-life',
				'fab fa-staylinked',
				'fab fa-steam',
				'fab fa-steam-square',
				'fab fa-steam-symbol',
				'fas fa-step-backward',
				'fas fa-step-forward',
				'fas fa-stethoscope',
				'fab fa-sticker-mule',
				'fas fa-sticky-note',
				'far fa-sticky-note',
				'fas fa-stop',
				'fas fa-stop-circle',
				'far fa-stop-circle',
				'fas fa-stopwatch',
				'fas fa-stopwatch-20',
				'fas fa-store',
				'fas fa-store-alt',
				'fas fa-store-alt-slash',
				'fas fa-store-slash',
				'fab fa-strava',
				'fas fa-stream',
				'fas fa-street-view',
				'fas fa-strikethrough',
				'fab fa-stripe',
				'fab fa-stripe-s',
				'fas fa-stroopwafel',
				'fab fa-studiovinari',
				'fab fa-stumbleupon',
				'fab fa-stumbleupon-circle',
				'fas fa-subscript',
				'fas fa-subway',
				'fas fa-suitcase',
				'fas fa-suitcase-rolling',
				'fas fa-sun',
				'far fa-sun',
				'fab fa-superpowers',
				'fas fa-superscript',
				'fab fa-supple',
				'fas fa-surprise',
				'far fa-surprise',
				'fab fa-suse',
				'fas fa-swatchbook',
				'fab fa-swift',
				'fas fa-swimmer',
				'fas fa-swimming-pool',
				'fab fa-symfony',
				'fas fa-synagogue',
				'fas fa-sync',
				'fas fa-sync-alt',
				'fas fa-syringe',
				'fas fa-table',
				'fas fa-table-tennis',
				'fas fa-tablet',
				'fas fa-tablet-alt',
				'fas fa-tablets',
				'fas fa-tachometer-alt',
				'fas fa-tag',
				'fas fa-tags',
				'fas fa-tape',
				'fas fa-tasks',
				'fas fa-taxi',
				'fab fa-teamspeak',
				'fas fa-teeth',
				'fas fa-teeth-open',
				'fab fa-telegram',
				'fab fa-telegram-plane',
				'fas fa-temperature-high',
				'fas fa-temperature-low',
				'fab fa-tencent-weibo',
				'fas fa-tenge',
				'fas fa-terminal',
				'fas fa-text-height',
				'fas fa-text-width',
				'fas fa-th',
				'fas fa-th-large',
				'fas fa-th-list',
				'fab fa-the-red-yeti',
				'fas fa-theater-masks',
				'fab fa-themeco',
				'fab fa-themeisle',
				'fas fa-thermometer',
				'fas fa-thermometer-empty',
				'fas fa-thermometer-full',
				'fas fa-thermometer-half',
				'fas fa-thermometer-quarter',
				'fas fa-thermometer-three-quarters',
				'fab fa-think-peaks',
				'fas fa-thumbs-down',
				'far fa-thumbs-down',
				'fas fa-thumbs-up',
				'far fa-thumbs-up',
				'fas fa-thumbtack',
				'fas fa-ticket-alt',
				'fab fa-tiktok',
				'fas fa-times',
				'fas fa-times-circle',
				'far fa-times-circle',
				'fas fa-tint',
				'fas fa-tint-slash',
				'fas fa-tired',
				'far fa-tired',
				'fas fa-toggle-off',
				'fas fa-toggle-on',
				'fas fa-toilet',
				'fas fa-toilet-paper',
				'fas fa-toilet-paper-slash',
				'fas fa-toolbox',
				'fas fa-tools',
				'fas fa-tooth',
				'fas fa-torah',
				'fas fa-torii-gate',
				'fas fa-tractor',
				'fab fa-trade-federation',
				'fas fa-trademark',
				'fas fa-traffic-light',
				'fas fa-trailer',
				'fas fa-train',
				'fas fa-tram',
				'fas fa-transgender',
				'fas fa-transgender-alt',
				'fas fa-trash',
				'fas fa-trash-alt',
				'far fa-trash-alt',
				'fas fa-trash-restore',
				'fas fa-trash-restore-alt',
				'fas fa-tree',
				'fab fa-trello',
				'fas fa-trophy',
				'fas fa-truck',
				'fas fa-truck-loading',
				'fas fa-truck-monster',
				'fas fa-truck-moving',
				'fas fa-truck-pickup',
				'fas fa-tshirt',
				'fas fa-tty',
				'fab fa-tumblr',
				'fab fa-tumblr-square',
				'fas fa-tv',
				'fab fa-twitch',
				'fab fa-twitter',
				'fab fa-twitter-square',
				'fab fa-typo3',
				'fab fa-uber',
				'fab fa-ubuntu',
				'fab fa-uikit',
				'fab fa-umbraco',
				'fas fa-umbrella',
				'fas fa-umbrella-beach',
				'fab fa-uncharted',
				'fas fa-underline',
				'fas fa-undo',
				'fas fa-undo-alt',
				'fab fa-uniregistry',
				'fab fa-unity',
				'fas fa-universal-access',
				'fas fa-university',
				'fas fa-unlink',
				'fas fa-unlock',
				'fas fa-unlock-alt',
				'fab fa-unsplash',
				'fab fa-untappd',
				'fas fa-upload',
				'fab fa-ups',
				'fab fa-usb',
				'fas fa-user',
				'far fa-user',
				'fas fa-user-alt',
				'fas fa-user-alt-slash',
				'fas fa-user-astronaut',
				'fas fa-user-check',
				'fas fa-user-circle',
				'far fa-user-circle',
				'fas fa-user-clock',
				'fas fa-user-cog',
				'fas fa-user-edit',
				'fas fa-user-friends',
				'fas fa-user-graduate',
				'fas fa-user-injured',
				'fas fa-user-lock',
				'fas fa-user-md',
				'fas fa-user-minus',
				'fas fa-user-ninja',
				'fas fa-user-nurse',
				'fas fa-user-plus',
				'fas fa-user-secret',
				'fas fa-user-shield',
				'fas fa-user-slash',
				'fas fa-user-tag',
				'fas fa-user-tie',
				'fas fa-user-times',
				'fas fa-users',
				'fas fa-users-cog',
				'fas fa-users-slash',
				'fab fa-usps',
				'fab fa-ussunnah',
				'fas fa-utensil-spoon',
				'fas fa-utensils',
				'fab fa-vaadin',
				'fas fa-vector-square',
				'fas fa-venus',
				'fas fa-venus-double',
				'fas fa-venus-mars',
				'fas fa-vest',
				'fas fa-vest-patches',
				'fab fa-viacoin',
				'fab fa-viadeo',
				'fab fa-viadeo-square',
				'fas fa-vial',
				'fas fa-vials',
				'fab fa-viber',
				'fas fa-video',
				'fas fa-video-slash',
				'fas fa-vihara',
				'fab fa-vimeo',
				'fab fa-vimeo-square',
				'fab fa-vimeo-v',
				'fab fa-vine',
				'fas fa-virus',
				'fas fa-virus-slash',
				'fas fa-viruses',
				'fab fa-vk',
				'fab fa-vnv',
				'fas fa-voicemail',
				'fas fa-volleyball-ball',
				'fas fa-volume-down',
				'fas fa-volume-mute',
				'fas fa-volume-off',
				'fas fa-volume-up',
				'fas fa-vote-yea',
				'fas fa-vr-cardboard',
				'fab fa-vuejs',
				'fas fa-walking',
				'fas fa-wallet',
				'fas fa-warehouse',
				'fab fa-watchman-monitoring',
				'fas fa-water',
				'fas fa-wave-square',
				'fab fa-waze',
				'fab fa-weebly',
				'fab fa-weibo',
				'fas fa-weight',
				'fas fa-weight-hanging',
				'fab fa-weixin',
				'fab fa-whatsapp',
				'fab fa-whatsapp-square',
				'fas fa-wheelchair',
				'fab fa-whmcs',
				'fas fa-wifi',
				'fab fa-wikipedia-w',
				'fas fa-wind',
				'fas fa-window-close',
				'far fa-window-close',
				'fas fa-window-maximize',
				'far fa-window-maximize',
				'fas fa-window-minimize',
				'far fa-window-minimize',
				'fas fa-window-restore',
				'far fa-window-restore',
				'fab fa-windows',
				'fas fa-wine-bottle',
				'fas fa-wine-glass',
				'fas fa-wine-glass-alt',
				'fab fa-wix',
				'fab fa-wizards-of-the-coast',
				'fab fa-wodu',
				'fab fa-wolf-pack-battalion',
				'fas fa-won-sign',
				'fab fa-wordpress',
				'fab fa-wordpress-simple',
				'fab fa-wpbeginner',
				'fab fa-wpexplorer',
				'fab fa-wpforms',
				'fab fa-wpressr',
				'fas fa-wrench',
				'fas fa-x-ray',
				'fab fa-xbox',
				'fab fa-xing',
				'fab fa-xing-square',
				'fab fa-y-combinator',
				'fab fa-yahoo',
				'fab fa-yammer',
				'fab fa-yandex',
				'fab fa-yandex-international',
				'fab fa-yarn',
				'fab fa-yelp',
				'fas fa-yen-sign',
				'fas fa-yin-yang',
				'fab fa-yoast',
				'fab fa-youtube',
				'fab fa-youtube-square',
				'fab fa-zhihu'
			);

			return $icons;
		}

		public function fontawesome_six_icons() {
			$icons = array(
				'fa-brands fa-monero',
				'fa-brands fa-hooli',
				'fa-brands fa-yelp',
				'fa-brands fa-cc-visa',
				'fa-brands fa-lastfm',
				'fa-brands fa-shopware',
				'fa-brands fa-creative-commons-nc',
				'fa-brands fa-aws',
				'fa-brands fa-redhat',
				'fa-brands fa-yoast',
				'fa-brands fa-cloudflare',
				'fa-brands fa-ups',
				'fa-brands fa-wpexplorer',
				'fa-brands fa-dyalog',
				'fa-brands fa-bity',
				'fa-brands fa-stackpath',
				'fa-brands fa-buysellads',
				'fa-brands fa-first-order',
				'fa-brands fa-modx',
				'fa-brands fa-guilded',
				'fa-brands fa-vnv',
				'fa-brands fa-square-js',
				'fa-brands fa-js-square',
				'fa-brands fa-microsoft',
				'fa-brands fa-qq',
				'fa-brands fa-orcid',
				'fa-brands fa-java',
				'fa-brands fa-invision',
				'fa-brands fa-creative-commons-pd-alt',
				'fa-brands fa-centercode',
				'fa-brands fa-glide-g',
				'fa-brands fa-drupal',
				'fa-brands fa-hire-a-helper',
				'fa-brands fa-creative-commons-by',
				'fa-brands fa-unity',
				'fa-brands fa-whmcs',
				'fa-brands fa-rocketchat',
				'fa-brands fa-vk',
				'fa-brands fa-untappd',
				'fa-brands fa-mailchimp',
				'fa-brands fa-css3-alt',
				'fa-brands fa-square-reddit',
				'fa-brands fa-reddit-square',
				'fa-brands fa-vimeo-v',
				'fa-brands fa-contao',
				'fa-brands fa-square-font-awesome',
				'fa-brands fa-deskpro',
				'fa-brands fa-sistrix',
				'fa-brands fa-square-instagram',
				'fa-brands fa-instagram-square',
				'fa-brands fa-battle-net',
				'fa-brands fa-the-red-yeti',
				'fa-brands fa-square-hacker-news',
				'fa-brands fa-hacker-news-square',
				'fa-brands fa-edge',
				'fa-brands fa-napster',
				'fa-brands fa-square-snapchat',
				'fa-brands fa-snapchat-square',
				'fa-brands fa-google-plus-g',
				'fa-brands fa-artstation',
				'fa-brands fa-markdown',
				'fa-brands fa-sourcetree',
				'fa-brands fa-google-plus',
				'fa-brands fa-diaspora',
				'fa-brands fa-foursquare',
				'fa-brands fa-stack-overflow',
				'fa-brands fa-github-alt',
				'fa-brands fa-phoenix-squadron',
				'fa-brands fa-pagelines',
				'fa-brands fa-algolia',
				'fa-brands fa-red-river',
				'fa-brands fa-creative-commons-sa',
				'fa-brands fa-safari',
				'fa-brands fa-google',
				'fa-brands fa-square-font-awesome-stroke',
				'fa-brands fa-font-awesome-alt',
				'fa-brands fa-atlassian',
				'fa-brands fa-linkedin-in',
				'fa-brands fa-digital-ocean',
				'fa-brands fa-nimblr',
				'fa-brands fa-chromecast',
				'fa-brands fa-evernote',
				'fa-brands fa-hacker-news',
				'fa-brands fa-creative-commons-sampling',
				'fa-brands fa-adversal',
				'fa-brands fa-creative-commons',
				'fa-brands fa-watchman-monitoring',
				'fa-brands fa-fonticons',
				'fa-brands fa-weixin',
				'fa-brands fa-shirtsinbulk',
				'fa-brands fa-codepen',
				'fa-brands fa-git-alt',
				'fa-brands fa-lyft',
				'fa-brands fa-rev',
				'fa-brands fa-windows',
				'fa-brands fa-wizards-of-the-coast',
				'fa-brands fa-square-viadeo',
				'fa-brands fa-viadeo-square',
				'fa-brands fa-meetup',
				'fa-brands fa-centos',
				'fa-brands fa-adn',
				'fa-brands fa-cloudsmith',
				'fa-brands fa-pied-piper-alt',
				'fa-brands fa-square-dribbble',
				'fa-brands fa-dribbble-square',
				'fa-brands fa-codiepie',
				'fa-brands fa-node',
				'fa-brands fa-mix',
				'fa-brands fa-steam',
				'fa-brands fa-cc-apple-pay',
				'fa-brands fa-scribd',
				'fa-brands fa-openid',
				'fa-brands fa-instalod',
				'fa-brands fa-expeditedssl',
				'fa-brands fa-sellcast',
				'fa-brands fa-square-twitter',
				'fa-brands fa-twitter-square',
				'fa-brands fa-r-project',
				'fa-brands fa-delicious',
				'fa-brands fa-freebsd',
				'fa-brands fa-vuejs',
				'fa-brands fa-accusoft',
				'fa-brands fa-ioxhost',
				'fa-brands fa-fonticons-fi',
				'fa-brands fa-app-store',
				'fa-brands fa-cc-mastercard',
				'fa-brands fa-itunes-note',
				'fa-brands fa-golang',
				'fa-brands fa-kickstarter',
				'fa-brands fa-grav',
				'fa-brands fa-weibo',
				'fa-brands fa-uncharted',
				'fa-brands fa-firstdraft',
				'fa-brands fa-square-youtube',
				'fa-brands fa-youtube-square',
				'fa-brands fa-wikipedia-w',
				'fa-brands fa-wpressr',
				'fa-brands fa-rendact',
				'fa-brands fa-angellist',
				'fa-brands fa-galactic-republic',
				'fa-brands fa-nfc-directional',
				'fa-brands fa-skype',
				'fa-brands fa-joget',
				'fa-brands fa-fedora',
				'fa-brands fa-stripe-s',
				'fa-brands fa-meta',
				'fa-brands fa-laravel',
				'fa-brands fa-hotjar',
				'fa-brands fa-bluetooth-b',
				'fa-brands fa-sticker-mule',
				'fa-brands fa-creative-commons-zero',
				'fa-brands fa-hips',
				'fa-brands fa-behance',
				'fa-brands fa-reddit',
				'fa-brands fa-discord',
				'fa-brands fa-chrome',
				'fa-brands fa-app-store-ios',
				'fa-brands fa-cc-discover',
				'fa-brands fa-wpbeginner',
				'fa-brands fa-confluence',
				'fa-brands fa-mdb',
				'fa-brands fa-dochub',
				'fa-brands fa-accessible-icon',
				'fa-brands fa-ebay',
				'fa-brands fa-amazon',
				'fa-brands fa-unsplash',
				'fa-brands fa-yarn',
				'fa-brands fa-square-steam',
				'fa-brands fa-steam-square',
				'fa-brands fa-500px',
				'fa-brands fa-square-vimeo',
				'fa-brands fa-vimeo-square',
				'fa-brands fa-asymmetrik',
				'fa-brands fa-font-awesome',
				'fa-brands fa-font-awesome-flag',
				'fa-brands fa-font-awesome-logo-full',
				'fa-brands fa-gratipay',
				'fa-brands fa-apple',
				'fa-brands fa-hive',
				'fa-brands fa-gitkraken',
				'fa-brands fa-keybase',
				'fa-brands fa-apple-pay',
				'fa-brands fa-padlet',
				'fa-brands fa-amazon-pay',
				'fa-brands fa-square-github',
				'fa-brands fa-github-square',
				'fa-brands fa-stumbleupon',
				'fa-brands fa-fedex',
				'fa-brands fa-phoenix-framework',
				'fa-brands fa-shopify',
				'fa-brands fa-neos',
				'fa-brands fa-hackerrank',
				'fa-brands fa-researchgate',
				'fa-brands fa-swift',
				'fa-brands fa-angular',
				'fa-brands fa-speakap',
				'fa-brands fa-angrycreative',
				'fa-brands fa-y-combinator',
				'fa-brands fa-empire',
				'fa-brands fa-envira',
				'fa-brands fa-square-gitlab',
				'fa-brands fa-gitlab-square',
				'fa-brands fa-studiovinari',
				'fa-brands fa-pied-piper',
				'fa-brands fa-wordpress',
				'fa-brands fa-product-hunt',
				'fa-brands fa-firefox',
				'fa-brands fa-linode',
				'fa-brands fa-goodreads',
				'fa-brands fa-square-odnoklassniki',
				'fa-brands fa-odnoklassniki-square',
				'fa-brands fa-jsfiddle',
				'fa-brands fa-sith',
				'fa-brands fa-themeisle',
				'fa-brands fa-page4',
				'fa-brands fa-hashnode',
				'fa-brands fa-react',
				'fa-brands fa-cc-paypal',
				'fa-brands fa-squarespace',
				'fa-brands fa-cc-stripe',
				'fa-brands fa-creative-commons-share',
				'fa-brands fa-bitcoin',
				'fa-brands fa-keycdn',
				'fa-brands fa-opera',
				'fa-brands fa-itch-io',
				'fa-brands fa-umbraco',
				'fa-brands fa-galactic-senate',
				'fa-brands fa-ubuntu',
				'fa-brands fa-draft2digital',
				'fa-brands fa-stripe',
				'fa-brands fa-houzz',
				'fa-brands fa-gg',
				'fa-brands fa-dhl',
				'fa-brands fa-square-pinterest',
				'fa-brands fa-pinterest-square',
				'fa-brands fa-xing',
				'fa-brands fa-blackberry',
				'fa-brands fa-creative-commons-pd',
				'fa-brands fa-playstation',
				'fa-brands fa-quinscape',
				'fa-brands fa-less',
				'fa-brands fa-blogger-b',
				'fa-brands fa-opencart',
				'fa-brands fa-vine',
				'fa-brands fa-paypal',
				'fa-brands fa-gitlab',
				'fa-brands fa-typo3',
				'fa-brands fa-reddit-alien',
				'fa-brands fa-yahoo',
				'fa-brands fa-dailymotion',
				'fa-brands fa-affiliatetheme',
				'fa-brands fa-pied-piper-pp',
				'fa-brands fa-bootstrap',
				'fa-brands fa-odnoklassniki',
				'fa-brands fa-nfc-symbol',
				'fa-brands fa-ethereum',
				'fa-brands fa-speaker-deck',
				'fa-brands fa-creative-commons-nc-eu',
				'fa-brands fa-patreon',
				'fa-brands fa-avianex',
				'fa-brands fa-ello',
				'fa-brands fa-gofore',
				'fa-brands fa-bimobject',
				'fa-brands fa-facebook-f',
				'fa-brands fa-square-google-plus',
				'fa-brands fa-google-plus-square',
				'fa-brands fa-mandalorian',
				'fa-brands fa-first-order-alt',
				'fa-brands fa-osi',
				'fa-brands fa-google-wallet',
				'fa-brands fa-d-and-d-beyond',
				'fa-brands fa-periscope',
				'fa-brands fa-fulcrum',
				'fa-brands fa-cloudscale',
				'fa-brands fa-forumbee',
				'fa-brands fa-mizuni',
				'fa-brands fa-schlix',
				'fa-brands fa-square-xing',
				'fa-brands fa-xing-square',
				'fa-brands fa-bandcamp',
				'fa-brands fa-wpforms',
				'fa-brands fa-cloudversify',
				'fa-brands fa-usps',
				'fa-brands fa-megaport',
				'fa-brands fa-magento',
				'fa-brands fa-spotify',
				'fa-brands fa-optin-monster',
				'fa-brands fa-fly',
				'fa-brands fa-aviato',
				'fa-brands fa-itunes',
				'fa-brands fa-cuttlefish',
				'fa-brands fa-blogger',
				'fa-brands fa-flickr',
				'fa-brands fa-viber',
				'fa-brands fa-soundcloud',
				'fa-brands fa-digg',
				'fa-brands fa-tencent-weibo',
				'fa-brands fa-symfony',
				'fa-brands fa-maxcdn',
				'fa-brands fa-etsy',
				'fa-brands fa-facebook-messenger',
				'fa-brands fa-audible',
				'fa-brands fa-think-peaks',
				'fa-brands fa-bilibili',
				'fa-brands fa-erlang',
				'fa-brands fa-cotton-bureau',
				'fa-brands fa-dashcube',
				'fa-brands fa-42-group',
				'fa-brands fa-innosoft',
				'fa-brands fa-stack-exchange',
				'fa-brands fa-elementor',
				'fa-brands fa-square-pied-piper',
				'fa-brands fa-pied-piper-square',
				'fa-brands fa-creative-commons-nd',
				'fa-brands fa-palfed',
				'fa-brands fa-superpowers',
				'fa-brands fa-resolving',
				'fa-brands fa-xbox',
				'fa-brands fa-searchengin',
				'fa-brands fa-tiktok',
				'fa-brands fa-square-facebook',
				'fa-brands fa-facebook-square',
				'fa-brands fa-renren',
				'fa-brands fa-linux',
				'fa-brands fa-glide',
				'fa-brands fa-linkedin',
				'fa-brands fa-hubspot',
				'fa-brands fa-deploydog',
				'fa-brands fa-twitch',
				'fa-brands fa-ravelry',
				'fa-brands fa-mixer',
				'fa-brands fa-square-lastfm',
				'fa-brands fa-lastfm-square',
				'fa-brands fa-vimeo',
				'fa-brands fa-mendeley',
				'fa-brands fa-uniregistry',
				'fa-brands fa-figma',
				'fa-brands fa-creative-commons-remix',
				'fa-brands fa-cc-amazon-pay',
				'fa-brands fa-dropbox',
				'fa-brands fa-instagram',
				'fa-brands fa-cmplid',
				'fa-brands fa-facebook',
				'fa-brands fa-gripfire',
				'fa-brands fa-jedi-order',
				'fa-brands fa-uikit',
				'fa-brands fa-fort-awesome-alt',
				'fa-brands fa-phabricator',
				'fa-brands fa-ussunnah',
				'fa-brands fa-earlybirds',
				'fa-brands fa-trade-federation',
				'fa-brands fa-autoprefixer',
				'fa-brands fa-whatsapp',
				'fa-brands fa-slideshare',
				'fa-brands fa-google-play',
				'fa-brands fa-viadeo',
				'fa-brands fa-line',
				'fa-brands fa-google-drive',
				'fa-brands fa-servicestack',
				'fa-brands fa-simplybuilt',
				'fa-brands fa-bitbucket',
				'fa-brands fa-imdb',
				'fa-brands fa-deezer',
				'fa-brands fa-raspberry-pi',
				'fa-brands fa-jira',
				'fa-brands fa-docker',
				'fa-brands fa-screenpal',
				'fa-brands fa-bluetooth',
				'fa-brands fa-gitter',
				'fa-brands fa-d-and-d',
				'fa-brands fa-microblog',
				'fa-brands fa-cc-diners-club',
				'fa-brands fa-gg-circle',
				'fa-brands fa-pied-piper-hat',
				'fa-brands fa-kickstarter-k',
				'fa-brands fa-yandex',
				'fa-brands fa-readme',
				'fa-brands fa-html5',
				'fa-brands fa-sellsy',
				'fa-brands fa-sass',
				'fa-brands fa-wirsindhandwerk',
				'fa-brands fa-wsh',
				'fa-brands fa-buromobelexperte',
				'fa-brands fa-salesforce',
				'fa-brands fa-octopus-deploy',
				'fa-brands fa-medapps',
				'fa-brands fa-ns8',
				'fa-brands fa-pinterest-p',
				'fa-brands fa-apper',
				'fa-brands fa-fort-awesome',
				'fa-brands fa-waze',
				'fa-brands fa-cc-jcb',
				'fa-brands fa-snapchat',
				'fa-brands fa-snapchat-ghost',
				'fa-brands fa-fantasy-flight-games',
				'fa-brands fa-rust',
				'fa-brands fa-wix',
				'fa-brands fa-square-behance',
				'fa-brands fa-behance-square',
				'fa-brands fa-supple',
				'fa-brands fa-rebel',
				'fa-brands fa-css3',
				'fa-brands fa-staylinked',
				'fa-brands fa-kaggle',
				'fa-brands fa-space-awesome',
				'fa-brands fa-deviantart',
				'fa-brands fa-cpanel',
				'fa-brands fa-goodreads-g',
				'fa-brands fa-square-git',
				'fa-brands fa-git-square',
				'fa-brands fa-square-tumblr',
				'fa-brands fa-tumblr-square',
				'fa-brands fa-trello',
				'fa-brands fa-creative-commons-nc-jp',
				'fa-brands fa-get-pocket',
				'fa-brands fa-perbyte',
				'fa-brands fa-grunt',
				'fa-brands fa-weebly',
				'fa-brands fa-connectdevelop',
				'fa-brands fa-leanpub',
				'fa-brands fa-black-tie',
				'fa-brands fa-themeco',
				'fa-brands fa-python',
				'fa-brands fa-android',
				'fa-brands fa-bots',
				'fa-brands fa-free-code-camp',
				'fa-brands fa-hornbill',
				'fa-brands fa-js',
				'fa-brands fa-ideal',
				'fa-brands fa-git',
				'fa-brands fa-dev',
				'fa-brands fa-sketch',
				'fa-brands fa-yandex-international',
				'fa-brands fa-cc-amex',
				'fa-brands fa-uber',
				'fa-brands fa-github',
				'fa-brands fa-php',
				'fa-brands fa-alipay',
				'fa-brands fa-youtube',
				'fa-brands fa-skyatlas',
				'fa-brands fa-firefox-browser',
				'fa-brands fa-replyd',
				'fa-brands fa-suse',
				'fa-brands fa-jenkins',
				'fa-brands fa-twitter',
				'fa-brands fa-rockrms',
				'fa-brands fa-pinterest',
				'fa-brands fa-buffer',
				'fa-brands fa-npm',
				'fa-brands fa-yammer',
				'fa-brands fa-btc',
				'fa-brands fa-dribbble',
				'fa-brands fa-stumbleupon-circle',
				'fa-brands fa-internet-explorer',
				'fa-brands fa-telegram',
				'fa-brands fa-telegram-plane',
				'fa-brands fa-old-republic',
				'fa-brands fa-square-whatsapp',
				'fa-brands fa-whatsapp-square',
				'fa-brands fa-node-js',
				'fa-brands fa-edge-legacy',
				'fa-brands fa-slack',
				'fa-brands fa-slack-hash',
				'fa-brands fa-medrt',
				'fa-brands fa-usb',
				'fa-brands fa-tumblr',
				'fa-brands fa-vaadin',
				'fa-brands fa-quora',
				'fa-brands fa-reacteurope',
				'fa-brands fa-medium',
				'fa-brands fa-medium-m',
				'fa-brands fa-amilia',
				'fa-brands fa-mixcloud',
				'fa-brands fa-flipboard',
				'fa-brands fa-viacoin',
				'fa-brands fa-critical-role',
				'fa-brands fa-sitrox',
				'fa-brands fa-discourse',
				'fa-brands fa-joomla',
				'fa-brands fa-mastodon',
				'fa-brands fa-airbnb',
				'fa-brands fa-wolf-pack-battalion',
				'fa-brands fa-buy-n-large',
				'fa-brands fa-gulp',
				'fa-brands fa-creative-commons-sampling-plus',
				'fa-brands fa-strava',
				'fa-brands fa-ember',
				'fa-brands fa-canadian-maple-leaf',
				'fa-brands fa-teamspeak',
				'fa-brands fa-pushed',
				'fa-brands fa-wordpress-simple',
				'fa-brands fa-nutritionix',
				'fa-brands fa-wodu',
				'fa-brands fa-google-pay',
				'fa-brands fa-intercom',
				'fa-brands fa-zhihu',
				'fa-brands fa-korvue',
				'fa-brands fa-pix',
				'fa-brands fa-steam-symbol',
			);

			return $icons;
		}

		public function remix_icon() {
			$remix_icons = array(
				'ri-24-hours-fill',
				'ri-24-hours-line',
				'ri-4k-fill',
				'ri-4k-line',
				'ri-a-b',
				'ri-account-box-fill',
				'ri-account-box-line',
				'ri-account-circle-fill',
				'ri-account-circle-line',
				'ri-account-pin-box-fill',
				'ri-account-pin-box-line',
				'ri-account-pin-circle-fill',
				'ri-account-pin-circle-line',
				'ri-add-box-fill',
				'ri-add-box-line',
				'ri-add-circle-fill',
				'ri-add-circle-line',
				'ri-add-fill',
				'ri-add-line',
				'ri-admin-fill',
				'ri-admin-line',
				'ri-advertisement-fill',
				'ri-advertisement-line',
				'ri-airplay-fill',
				'ri-airplay-line',
				'ri-alarm-fill',
				'ri-alarm-line',
				'ri-alarm-warning-fill',
				'ri-alarm-warning-line',
				'ri-album-fill',
				'ri-album-line',
				'ri-alert-fill',
				'ri-alert-line',
				'ri-aliens-fill',
				'ri-aliens-line',
				'ri-align-bottom',
				'ri-align-center',
				'ri-align-justify',
				'ri-align-left',
				'ri-align-right',
				'ri-align-top',
				'ri-align-vertically',
				'ri-alipay-fill',
				'ri-alipay-line',
				'ri-amazon-fill',
				'ri-amazon-line',
				'ri-anchor-fill',
				'ri-anchor-line',
				'ri-ancient-gate-fill',
				'ri-ancient-gate-line',
				'ri-ancient-pavilion-fill',
				'ri-ancient-pavilion-line',
				'ri-android-fill',
				'ri-android-line',
				'ri-angularjs-fill',
				'ri-angularjs-line',
				'ri-anticlockwise-2-fill',
				'ri-anticlockwise-2-line',
				'ri-anticlockwise-fill',
				'ri-anticlockwise-line',
				'ri-app-store-fill',
				'ri-app-store-line',
				'ri-apple-fill',
				'ri-apple-line',
				'ri-apps-2-fill',
				'ri-apps-2-line',
				'ri-apps-fill',
				'ri-apps-line',
				'ri-archive-drawer-fill',
				'ri-archive-drawer-line',
				'ri-archive-fill',
				'ri-archive-line',
				'ri-arrow-down-circle-fill',
				'ri-arrow-down-circle-line',
				'ri-arrow-down-fill',
				'ri-arrow-down-line',
				'ri-arrow-down-s-fill',
				'ri-arrow-down-s-line',
				'ri-arrow-drop-down-fill',
				'ri-arrow-drop-down-line',
				'ri-arrow-drop-left-fill',
				'ri-arrow-drop-left-line',
				'ri-arrow-drop-right-fill',
				'ri-arrow-drop-right-line',
				'ri-arrow-drop-up-fill',
				'ri-arrow-drop-up-line',
				'ri-arrow-go-back-fill',
				'ri-arrow-go-back-line',
				'ri-arrow-go-forward-fill',
				'ri-arrow-go-forward-line',
				'ri-arrow-left-circle-fill',
				'ri-arrow-left-circle-line',
				'ri-arrow-left-down-fill',
				'ri-arrow-left-down-line',
				'ri-arrow-left-fill',
				'ri-arrow-left-line',
				'ri-arrow-left-right-fill',
				'ri-arrow-left-right-line',
				'ri-arrow-left-s-fill',
				'ri-arrow-left-s-line',
				'ri-arrow-left-up-fill',
				'ri-arrow-left-up-line',
				'ri-arrow-right-circle-fill',
				'ri-arrow-right-circle-line',
				'ri-arrow-right-down-fill',
				'ri-arrow-right-down-line',
				'ri-arrow-right-fill',
				'ri-arrow-right-line',
				'ri-arrow-right-s-fill',
				'ri-arrow-right-s-line',
				'ri-arrow-right-up-fill',
				'ri-arrow-right-up-line',
				'ri-arrow-up-circle-fill',
				'ri-arrow-up-circle-line',
				'ri-arrow-up-down-fill',
				'ri-arrow-up-down-line',
				'ri-arrow-up-fill',
				'ri-arrow-up-line',
				'ri-arrow-up-s-fill',
				'ri-arrow-up-s-line',
				'ri-artboard-2-fill',
				'ri-artboard-2-line',
				'ri-artboard-fill',
				'ri-artboard-line',
				'ri-article-fill',
				'ri-article-line',
				'ri-aspect-ratio-fill',
				'ri-aspect-ratio-line',
				'ri-asterisk',
				'ri-at-fill',
				'ri-at-line',
				'ri-attachment-2',
				'ri-attachment-fill',
				'ri-attachment-line',
				'ri-auction-fill',
				'ri-auction-line',
				'ri-award-fill',
				'ri-award-line',
				'ri-baidu-fill',
				'ri-baidu-line',
				'ri-ball-pen-fill',
				'ri-ball-pen-line',
				'ri-bank-card-2-fill',
				'ri-bank-card-2-line',
				'ri-bank-card-fill',
				'ri-bank-card-line',
				'ri-bank-fill',
				'ri-bank-line',
				'ri-bar-chart-2-fill',
				'ri-bar-chart-2-line',
				'ri-bar-chart-box-fill',
				'ri-bar-chart-box-line',
				'ri-bar-chart-fill',
				'ri-bar-chart-grouped-fill',
				'ri-bar-chart-grouped-line',
				'ri-bar-chart-horizontal-fill',
				'ri-bar-chart-horizontal-line',
				'ri-bar-chart-line',
				'ri-barcode-box-fill',
				'ri-barcode-box-line',
				'ri-barcode-fill',
				'ri-barcode-line',
				'ri-barricade-fill',
				'ri-barricade-line',
				'ri-base-station-fill',
				'ri-base-station-line',
				'ri-basketball-fill',
				'ri-basketball-line',
				'ri-battery-2-charge-fill',
				'ri-battery-2-charge-line',
				'ri-battery-2-fill',
				'ri-battery-2-line',
				'ri-battery-charge-fill',
				'ri-battery-charge-line',
				'ri-battery-fill',
				'ri-battery-line',
				'ri-battery-low-fill',
				'ri-battery-low-line',
				'ri-battery-saver-fill',
				'ri-battery-saver-line',
				'ri-battery-share-fill',
				'ri-battery-share-line',
				'ri-bear-smile-fill',
				'ri-bear-smile-line',
				'ri-behance-fill',
				'ri-behance-line',
				'ri-bell-fill',
				'ri-bell-line',
				'ri-bike-fill',
				'ri-bike-line',
				'ri-bilibili-fill',
				'ri-bilibili-line',
				'ri-bill-fill',
				'ri-bill-line',
				'ri-billiards-fill',
				'ri-billiards-line',
				'ri-bit-coin-fill',
				'ri-bit-coin-line',
				'ri-blaze-fill',
				'ri-blaze-line',
				'ri-bluetooth-connect-fill',
				'ri-bluetooth-connect-line',
				'ri-bluetooth-fill',
				'ri-bluetooth-line',
				'ri-blur-off-fill',
				'ri-blur-off-line',
				'ri-body-scan-fill',
				'ri-body-scan-line',
				'ri-bold',
				'ri-book-2-fill',
				'ri-book-2-line',
				'ri-book-3-fill',
				'ri-book-3-line',
				'ri-book-fill',
				'ri-book-line',
				'ri-book-mark-fill',
				'ri-book-mark-line',
				'ri-book-open-fill',
				'ri-book-open-line',
				'ri-book-read-fill',
				'ri-book-read-line',
				'ri-booklet-fill',
				'ri-booklet-line',
				'ri-bookmark-2-fill',
				'ri-bookmark-2-line',
				'ri-bookmark-3-fill',
				'ri-bookmark-3-line',
				'ri-bookmark-fill',
				'ri-bookmark-line',
				'ri-boxing-fill',
				'ri-boxing-line',
				'ri-braces-fill',
				'ri-braces-line',
				'ri-brackets-fill',
				'ri-brackets-line',
				'ri-briefcase-2-fill',
				'ri-briefcase-2-line',
				'ri-briefcase-3-fill',
				'ri-briefcase-3-line',
				'ri-briefcase-4-fill',
				'ri-briefcase-4-line',
				'ri-briefcase-5-fill',
				'ri-briefcase-5-line',
				'ri-briefcase-fill',
				'ri-briefcase-line',
				'ri-bring-forward',
				'ri-bring-to-front',
				'ri-broadcast-fill',
				'ri-broadcast-line',
				'ri-brush-2-fill',
				'ri-brush-2-line',
				'ri-brush-3-fill',
				'ri-brush-3-line',
				'ri-brush-4-fill',
				'ri-brush-4-line',
				'ri-brush-fill',
				'ri-brush-line',
				'ri-bubble-chart-fill',
				'ri-bubble-chart-line',
				'ri-bug-2-fill',
				'ri-bug-2-line',
				'ri-bug-fill',
				'ri-bug-line',
				'ri-building-2-fill',
				'ri-building-2-line',
				'ri-building-3-fill',
				'ri-building-3-line',
				'ri-building-4-fill',
				'ri-building-4-line',
				'ri-building-fill',
				'ri-building-line',
				'ri-bus-2-fill',
				'ri-bus-2-line',
				'ri-bus-fill',
				'ri-bus-line',
				'ri-bus-wifi-fill',
				'ri-bus-wifi-line',
				'ri-cactus-fill',
				'ri-cactus-line',
				'ri-cake-2-fill',
				'ri-cake-2-line',
				'ri-cake-3-fill',
				'ri-cake-3-line',
				'ri-cake-fill',
				'ri-cake-line',
				'ri-calculator-fill',
				'ri-calculator-line',
				'ri-calendar-2-fill',
				'ri-calendar-2-line',
				'ri-calendar-check-fill',
				'ri-calendar-check-line',
				'ri-calendar-event-fill',
				'ri-calendar-event-line',
				'ri-calendar-fill',
				'ri-calendar-line',
				'ri-calendar-todo-fill',
				'ri-calendar-todo-line',
				'ri-camera-2-fill',
				'ri-camera-2-line',
				'ri-camera-3-fill',
				'ri-camera-3-line',
				'ri-camera-fill',
				'ri-camera-lens-fill',
				'ri-camera-lens-line',
				'ri-camera-line',
				'ri-camera-off-fill',
				'ri-camera-off-line',
				'ri-camera-switch-fill',
				'ri-camera-switch-line',
				'ri-capsule-fill',
				'ri-capsule-line',
				'ri-car-fill',
				'ri-car-line',
				'ri-car-washing-fill',
				'ri-car-washing-line',
				'ri-caravan-fill',
				'ri-caravan-line',
				'ri-cast-fill',
				'ri-cast-line',
				'ri-cellphone-fill',
				'ri-cellphone-line',
				'ri-celsius-fill',
				'ri-celsius-line',
				'ri-centos-fill',
				'ri-centos-line',
				'ri-character-recognition-fill',
				'ri-character-recognition-line',
				'ri-charging-pile-2-fill',
				'ri-charging-pile-2-line',
				'ri-charging-pile-fill',
				'ri-charging-pile-line',
				'ri-chat-1-fill',
				'ri-chat-1-line',
				'ri-chat-2-fill',
				'ri-chat-2-line',
				'ri-chat-3-fill',
				'ri-chat-3-line',
				'ri-chat-4-fill',
				'ri-chat-4-line',
				'ri-chat-check-fill',
				'ri-chat-check-line',
				'ri-chat-delete-fill',
				'ri-chat-delete-line',
				'ri-chat-download-fill',
				'ri-chat-download-line',
				'ri-chat-follow-up-fill',
				'ri-chat-follow-up-line',
				'ri-chat-forward-fill',
				'ri-chat-forward-line',
				'ri-chat-heart-fill',
				'ri-chat-heart-line',
				'ri-chat-history-fill',
				'ri-chat-history-line',
				'ri-chat-new-fill',
				'ri-chat-new-line',
				'ri-chat-off-fill',
				'ri-chat-off-line',
				'ri-chat-poll-fill',
				'ri-chat-poll-line',
				'ri-chat-private-fill',
				'ri-chat-private-line',
				'ri-chat-quote-fill',
				'ri-chat-quote-line',
				'ri-chat-settings-fill',
				'ri-chat-settings-line',
				'ri-chat-smile-2-fill',
				'ri-chat-smile-2-line',
				'ri-chat-smile-3-fill',
				'ri-chat-smile-3-line',
				'ri-chat-smile-fill',
				'ri-chat-smile-line',
				'ri-chat-upload-fill',
				'ri-chat-upload-line',
				'ri-chat-voice-fill',
				'ri-chat-voice-line',
				'ri-check-double-fill',
				'ri-check-double-line',
				'ri-check-fill',
				'ri-check-line',
				'ri-checkbox-blank-circle-fill',
				'ri-checkbox-blank-circle-line',
				'ri-checkbox-blank-fill',
				'ri-checkbox-blank-line',
				'ri-checkbox-circle-fill',
				'ri-checkbox-circle-line',
				'ri-checkbox-fill',
				'ri-checkbox-indeterminate-fill',
				'ri-checkbox-indeterminate-line',
				'ri-checkbox-line',
				'ri-checkbox-multiple-blank-fill',
				'ri-checkbox-multiple-blank-line',
				'ri-checkbox-multiple-fill',
				'ri-checkbox-multiple-line',
				'ri-china-railway-fill',
				'ri-china-railway-line',
				'ri-chrome-fill',
				'ri-chrome-line',
				'ri-clapperboard-fill',
				'ri-clapperboard-line',
				'ri-clipboard-fill',
				'ri-clipboard-line',
				'ri-clockwise-2-fill',
				'ri-clockwise-2-line',
				'ri-clockwise-fill',
				'ri-clockwise-line',
				'ri-close-circle-fill',
				'ri-close-circle-line',
				'ri-close-fill',
				'ri-close-line',
				'ri-closed-captioning-fill',
				'ri-closed-captioning-line',
				'ri-cloud-fill',
				'ri-cloud-line',
				'ri-cloud-off-fill',
				'ri-cloud-off-line',
				'ri-cloud-windy-fill',
				'ri-cloud-windy-line',
				'ri-cloudy-2-fill',
				'ri-cloudy-2-line',
				'ri-cloudy-fill',
				'ri-cloudy-line',
				'ri-code-box-fill',
				'ri-code-box-line',
				'ri-code-fill',
				'ri-code-line',
				'ri-code-s-fill',
				'ri-code-s-line',
				'ri-code-s-slash-fill',
				'ri-code-s-slash-line',
				'ri-code-view',
				'ri-codepen-fill',
				'ri-codepen-line',
				'ri-coin-fill',
				'ri-coin-line',
				'ri-coins-fill',
				'ri-coins-line',
				'ri-collage-fill',
				'ri-collage-line',
				'ri-command-fill',
				'ri-command-line',
				'ri-community-fill',
				'ri-community-line',
				'ri-compass-2-fill',
				'ri-compass-2-line',
				'ri-compass-3-fill',
				'ri-compass-3-line',
				'ri-compass-4-fill',
				'ri-compass-4-line',
				'ri-compass-discover-fill',
				'ri-compass-discover-line',
				'ri-compass-fill',
				'ri-compass-line',
				'ri-compasses-2-fill',
				'ri-compasses-2-line',
				'ri-compasses-fill',
				'ri-compasses-line',
				'ri-computer-fill',
				'ri-computer-line',
				'ri-contacts-book-2-fill',
				'ri-contacts-book-2-line',
				'ri-contacts-book-fill',
				'ri-contacts-book-line',
				'ri-contacts-book-upload-fill',
				'ri-contacts-book-upload-line',
				'ri-contacts-fill',
				'ri-contacts-line',
				'ri-contrast-2-fill',
				'ri-contrast-2-line',
				'ri-contrast-drop-2-fill',
				'ri-contrast-drop-2-line',
				'ri-contrast-drop-fill',
				'ri-contrast-drop-line',
				'ri-contrast-fill',
				'ri-contrast-line',
				'ri-copper-coin-fill',
				'ri-copper-coin-line',
				'ri-copper-diamond-fill',
				'ri-copper-diamond-line',
				'ri-copyleft-fill',
				'ri-copyleft-line',
				'ri-copyright-fill',
				'ri-copyright-line',
				'ri-coreos-fill',
				'ri-coreos-line',
				'ri-coupon-2-fill',
				'ri-coupon-2-line',
				'ri-coupon-3-fill',
				'ri-coupon-3-line',
				'ri-coupon-4-fill',
				'ri-coupon-4-line',
				'ri-coupon-5-fill',
				'ri-coupon-5-line',
				'ri-coupon-fill',
				'ri-coupon-line',
				'ri-cpu-fill',
				'ri-cpu-line',
				'ri-creative-commons-by-fill',
				'ri-creative-commons-by-line',
				'ri-creative-commons-fill',
				'ri-creative-commons-line',
				'ri-creative-commons-nc-fill',
				'ri-creative-commons-nc-line',
				'ri-creative-commons-nd-fill',
				'ri-creative-commons-nd-line',
				'ri-creative-commons-sa-fill',
				'ri-creative-commons-sa-line',
				'ri-creative-commons-zero-fill',
				'ri-creative-commons-zero-line',
				'ri-criminal-fill',
				'ri-criminal-line',
				'ri-crop-2-fill',
				'ri-crop-2-line',
				'ri-crop-fill',
				'ri-crop-line',
				'ri-css3-fill',
				'ri-css3-line',
				'ri-cup-fill',
				'ri-cup-line',
				'ri-currency-fill',
				'ri-currency-line',
				'ri-cursor-fill',
				'ri-cursor-line',
				'ri-customer-service-2-fill',
				'ri-customer-service-2-line',
				'ri-customer-service-fill',
				'ri-customer-service-line',
				'ri-dashboard-2-fill',
				'ri-dashboard-2-line',
				'ri-dashboard-3-fill',
				'ri-dashboard-3-line',
				'ri-dashboard-fill',
				'ri-dashboard-line',
				'ri-database-2-fill',
				'ri-database-2-line',
				'ri-database-fill',
				'ri-database-line',
				'ri-delete-back-2-fill',
				'ri-delete-back-2-line',
				'ri-delete-back-fill',
				'ri-delete-back-line',
				'ri-delete-bin-2-fill',
				'ri-delete-bin-2-line',
				'ri-delete-bin-3-fill',
				'ri-delete-bin-3-line',
				'ri-delete-bin-4-fill',
				'ri-delete-bin-4-line',
				'ri-delete-bin-5-fill',
				'ri-delete-bin-5-line',
				'ri-delete-bin-6-fill',
				'ri-delete-bin-6-line',
				'ri-delete-bin-7-fill',
				'ri-delete-bin-7-line',
				'ri-delete-bin-fill',
				'ri-delete-bin-line',
				'ri-delete-column',
				'ri-delete-row',
				'ri-device-fill',
				'ri-device-line',
				'ri-device-recover-fill',
				'ri-device-recover-line',
				'ri-dingding-fill',
				'ri-dingding-line',
				'ri-direction-fill',
				'ri-direction-line',
				'ri-disc-fill',
				'ri-disc-line',
				'ri-discord-fill',
				'ri-discord-line',
				'ri-discuss-fill',
				'ri-discuss-line',
				'ri-dislike-fill',
				'ri-dislike-line',
				'ri-disqus-fill',
				'ri-disqus-line',
				'ri-divide-fill',
				'ri-divide-line',
				'ri-donut-chart-fill',
				'ri-donut-chart-line',
				'ri-door-closed-fill',
				'ri-door-closed-line',
				'ri-door-fill',
				'ri-door-line',
				'ri-door-lock-box-fill',
				'ri-door-lock-box-line',
				'ri-door-lock-fill',
				'ri-door-lock-line',
				'ri-door-open-fill',
				'ri-door-open-line',
				'ri-dossier-fill',
				'ri-dossier-line',
				'ri-douban-fill',
				'ri-douban-line',
				'ri-double-quotes-l',
				'ri-double-quotes-r',
				'ri-download-2-fill',
				'ri-download-2-line',
				'ri-download-cloud-2-fill',
				'ri-download-cloud-2-line',
				'ri-download-cloud-fill',
				'ri-download-cloud-line',
				'ri-download-fill',
				'ri-download-line',
				'ri-draft-fill',
				'ri-draft-line',
				'ri-drag-drop-fill',
				'ri-drag-drop-line',
				'ri-drag-move-2-fill',
				'ri-drag-move-2-line',
				'ri-drag-move-fill',
				'ri-drag-move-line',
				'ri-dribbble-fill',
				'ri-dribbble-line',
				'ri-drive-fill',
				'ri-drive-line',
				'ri-drizzle-fill',
				'ri-drizzle-line',
				'ri-drop-fill',
				'ri-drop-line',
				'ri-dropbox-fill',
				'ri-dropbox-line',
				'ri-dual-sim-1-fill',
				'ri-dual-sim-1-line',
				'ri-dual-sim-2-fill',
				'ri-dual-sim-2-line',
				'ri-dv-fill',
				'ri-dv-line',
				'ri-dvd-fill',
				'ri-dvd-line',
				'ri-e-bike-2-fill',
				'ri-e-bike-2-line',
				'ri-e-bike-fill',
				'ri-e-bike-line',
				'ri-earth-fill',
				'ri-earth-line',
				'ri-earthquake-fill',
				'ri-earthquake-line',
				'ri-edge-fill',
				'ri-edge-line',
				'ri-edit-2-fill',
				'ri-edit-2-line',
				'ri-edit-box-fill',
				'ri-edit-box-line',
				'ri-edit-circle-fill',
				'ri-edit-circle-line',
				'ri-edit-fill',
				'ri-edit-line',
				'ri-eject-fill',
				'ri-eject-line',
				'ri-emotion-2-fill',
				'ri-emotion-2-line',
				'ri-emotion-fill',
				'ri-emotion-happy-fill',
				'ri-emotion-happy-line',
				'ri-emotion-laugh-fill',
				'ri-emotion-laugh-line',
				'ri-emotion-line',
				'ri-emotion-normal-fill',
				'ri-emotion-normal-line',
				'ri-emotion-sad-fill',
				'ri-emotion-sad-line',
				'ri-emotion-unhappy-fill',
				'ri-emotion-unhappy-line',
				'ri-empathize-fill',
				'ri-empathize-line',
				'ri-emphasis-cn',
				'ri-emphasis',
				'ri-english-input',
				'ri-equalizer-fill',
				'ri-equalizer-line',
				'ri-eraser-fill',
				'ri-eraser-line',
				'ri-error-warning-fill',
				'ri-error-warning-line',
				'ri-evernote-fill',
				'ri-evernote-line',
				'ri-exchange-box-fill',
				'ri-exchange-box-line',
				'ri-exchange-cny-fill',
				'ri-exchange-cny-line',
				'ri-exchange-dollar-fill',
				'ri-exchange-dollar-line',
				'ri-exchange-fill',
				'ri-exchange-funds-fill',
				'ri-exchange-funds-line',
				'ri-exchange-line',
				'ri-external-link-fill',
				'ri-external-link-line',
				'ri-eye-2-fill',
				'ri-eye-2-line',
				'ri-eye-close-fill',
				'ri-eye-close-line',
				'ri-eye-fill',
				'ri-eye-line',
				'ri-eye-off-fill',
				'ri-eye-off-line',
				'ri-facebook-box-fill',
				'ri-facebook-box-line',
				'ri-facebook-circle-fill',
				'ri-facebook-circle-line',
				'ri-facebook-fill',
				'ri-facebook-line',
				'ri-fahrenheit-fill',
				'ri-fahrenheit-line',
				'ri-feedback-fill',
				'ri-feedback-line',
				'ri-file-2-fill',
				'ri-file-2-line',
				'ri-file-3-fill',
				'ri-file-3-line',
				'ri-file-4-fill',
				'ri-file-4-line',
				'ri-file-add-fill',
				'ri-file-add-line',
				'ri-file-chart-2-fill',
				'ri-file-chart-2-line',
				'ri-file-chart-fill',
				'ri-file-chart-line',
				'ri-file-cloud-fill',
				'ri-file-cloud-line',
				'ri-file-code-fill',
				'ri-file-code-line',
				'ri-file-copy-2-fill',
				'ri-file-copy-2-line',
				'ri-file-copy-fill',
				'ri-file-copy-line',
				'ri-file-damage-fill',
				'ri-file-damage-line',
				'ri-file-download-fill',
				'ri-file-download-line',
				'ri-file-edit-fill',
				'ri-file-edit-line',
				'ri-file-excel-2-fill',
				'ri-file-excel-2-line',
				'ri-file-excel-fill',
				'ri-file-excel-line',
				'ri-file-fill',
				'ri-file-forbid-fill',
				'ri-file-forbid-line',
				'ri-file-gif-fill',
				'ri-file-gif-line',
				'ri-file-history-fill',
				'ri-file-history-line',
				'ri-file-hwp-fill',
				'ri-file-hwp-line',
				'ri-file-info-fill',
				'ri-file-info-line',
				'ri-file-line',
				'ri-file-list-2-fill',
				'ri-file-list-2-line',
				'ri-file-list-3-fill',
				'ri-file-list-3-line',
				'ri-file-list-fill',
				'ri-file-list-line',
				'ri-file-lock-fill',
				'ri-file-lock-line',
				'ri-file-mark-fill',
				'ri-file-mark-line',
				'ri-file-music-fill',
				'ri-file-music-line',
				'ri-file-paper-2-fill',
				'ri-file-paper-2-line',
				'ri-file-paper-fill',
				'ri-file-paper-line',
				'ri-file-pdf-fill',
				'ri-file-pdf-line',
				'ri-file-ppt-2-fill',
				'ri-file-ppt-2-line',
				'ri-file-ppt-fill',
				'ri-file-ppt-line',
				'ri-file-reduce-fill',
				'ri-file-reduce-line',
				'ri-file-search-fill',
				'ri-file-search-line',
				'ri-file-settings-fill',
				'ri-file-settings-line',
				'ri-file-shield-2-fill',
				'ri-file-shield-2-line',
				'ri-file-shield-fill',
				'ri-file-shield-line',
				'ri-file-shred-fill',
				'ri-file-shred-line',
				'ri-file-text-fill',
				'ri-file-text-line',
				'ri-file-transfer-fill',
				'ri-file-transfer-line',
				'ri-file-unknow-fill',
				'ri-file-unknow-line',
				'ri-file-upload-fill',
				'ri-file-upload-line',
				'ri-file-user-fill',
				'ri-file-user-line',
				'ri-file-warning-fill',
				'ri-file-warning-line',
				'ri-file-word-2-fill',
				'ri-file-word-2-line',
				'ri-file-word-fill',
				'ri-file-word-line',
				'ri-file-zip-fill',
				'ri-file-zip-line',
				'ri-film-fill',
				'ri-film-line',
				'ri-filter-2-fill',
				'ri-filter-2-line',
				'ri-filter-3-fill',
				'ri-filter-3-line',
				'ri-filter-fill',
				'ri-filter-line',
				'ri-filter-off-fill',
				'ri-filter-off-line',
				'ri-find-replace-fill',
				'ri-find-replace-line',
				'ri-finder-fill',
				'ri-finder-line',
				'ri-fingerprint-2-fill',
				'ri-fingerprint-2-line',
				'ri-fingerprint-fill',
				'ri-fingerprint-line',
				'ri-fire-fill',
				'ri-fire-line',
				'ri-firefox-fill',
				'ri-firefox-line',
				'ri-first-aid-kit-fill',
				'ri-first-aid-kit-line',
				'ri-flag-2-fill',
				'ri-flag-2-line',
				'ri-flag-fill',
				'ri-flag-line',
				'ri-flashlight-fill',
				'ri-flashlight-line',
				'ri-flask-fill',
				'ri-flask-line',
				'ri-flight-land-fill',
				'ri-flight-land-line',
				'ri-flight-takeoff-fill',
				'ri-flight-takeoff-line',
				'ri-flood-fill',
				'ri-flood-line',
				'ri-flow-chart',
				'ri-flutter-fill',
				'ri-flutter-line',
				'ri-focus-2-fill',
				'ri-focus-2-line',
				'ri-focus-3-fill',
				'ri-focus-3-line',
				'ri-focus-fill',
				'ri-focus-line',
				'ri-foggy-fill',
				'ri-foggy-line',
				'ri-folder-2-fill',
				'ri-folder-2-line',
				'ri-folder-3-fill',
				'ri-folder-3-line',
				'ri-folder-4-fill',
				'ri-folder-4-line',
				'ri-folder-5-fill',
				'ri-folder-5-line',
				'ri-folder-add-fill',
				'ri-folder-add-line',
				'ri-folder-chart-2-fill',
				'ri-folder-chart-2-line',
				'ri-folder-chart-fill',
				'ri-folder-chart-line',
				'ri-folder-download-fill',
				'ri-folder-download-line',
				'ri-folder-fill',
				'ri-folder-forbid-fill',
				'ri-folder-forbid-line',
				'ri-folder-history-fill',
				'ri-folder-history-line',
				'ri-folder-info-fill',
				'ri-folder-info-line',
				'ri-folder-keyhole-fill',
				'ri-folder-keyhole-line',
				'ri-folder-line',
				'ri-folder-lock-fill',
				'ri-folder-lock-line',
				'ri-folder-music-fill',
				'ri-folder-music-line',
				'ri-folder-open-fill',
				'ri-folder-open-line',
				'ri-folder-received-fill',
				'ri-folder-received-line',
				'ri-folder-reduce-fill',
				'ri-folder-reduce-line',
				'ri-folder-settings-fill',
				'ri-folder-settings-line',
				'ri-folder-shared-fill',
				'ri-folder-shared-line',
				'ri-folder-shield-2-fill',
				'ri-folder-shield-2-line',
				'ri-folder-shield-fill',
				'ri-folder-shield-line',
				'ri-folder-transfer-fill',
				'ri-folder-transfer-line',
				'ri-folder-unknow-fill',
				'ri-folder-unknow-line',
				'ri-folder-upload-fill',
				'ri-folder-upload-line',
				'ri-folder-user-fill',
				'ri-folder-user-line',
				'ri-folder-warning-fill',
				'ri-folder-warning-line',
				'ri-folder-zip-fill',
				'ri-folder-zip-line',
				'ri-folders-fill',
				'ri-folders-line',
				'ri-font-color',
				'ri-font-size-2',
				'ri-font-size',
				'ri-football-fill',
				'ri-football-line',
				'ri-footprint-fill',
				'ri-footprint-line',
				'ri-forbid-2-fill',
				'ri-forbid-2-line',
				'ri-forbid-fill',
				'ri-forbid-line',
				'ri-format-clear',
				'ri-fridge-fill',
				'ri-fridge-line',
				'ri-fullscreen-exit-fill',
				'ri-fullscreen-exit-line',
				'ri-fullscreen-fill',
				'ri-fullscreen-line',
				'ri-function-fill',
				'ri-function-line',
				'ri-functions',
				'ri-funds-box-fill',
				'ri-funds-box-line',
				'ri-funds-fill',
				'ri-funds-line',
				'ri-gallery-fill',
				'ri-gallery-line',
				'ri-gallery-upload-fill',
				'ri-gallery-upload-line',
				'ri-game-fill',
				'ri-game-line',
				'ri-gamepad-fill',
				'ri-gamepad-line',
				'ri-gas-station-fill',
				'ri-gas-station-line',
				'ri-gatsby-fill',
				'ri-gatsby-line',
				'ri-genderless-fill',
				'ri-genderless-line',
				'ri-ghost-2-fill',
				'ri-ghost-2-line',
				'ri-ghost-fill',
				'ri-ghost-line',
				'ri-ghost-smile-fill',
				'ri-ghost-smile-line',
				'ri-gift-2-fill',
				'ri-gift-2-line',
				'ri-gift-fill',
				'ri-gift-line',
				'ri-git-branch-fill',
				'ri-git-branch-line',
				'ri-git-commit-fill',
				'ri-git-commit-line',
				'ri-git-merge-fill',
				'ri-git-merge-line',
				'ri-git-pull-request-fill',
				'ri-git-pull-request-line',
				'ri-git-repository-commits-fill',
				'ri-git-repository-commits-line',
				'ri-git-repository-fill',
				'ri-git-repository-line',
				'ri-git-repository-private-fill',
				'ri-git-repository-private-line',
				'ri-github-fill',
				'ri-github-line',
				'ri-gitlab-fill',
				'ri-gitlab-line',
				'ri-global-fill',
				'ri-global-line',
				'ri-globe-fill',
				'ri-globe-line',
				'ri-goblet-fill',
				'ri-goblet-line',
				'ri-google-fill',
				'ri-google-line',
				'ri-google-play-fill',
				'ri-google-play-line',
				'ri-government-fill',
				'ri-government-line',
				'ri-gps-fill',
				'ri-gps-line',
				'ri-gradienter-fill',
				'ri-gradienter-line',
				'ri-grid-fill',
				'ri-grid-line',
				'ri-group-2-fill',
				'ri-group-2-line',
				'ri-group-fill',
				'ri-group-line',
				'ri-guide-fill',
				'ri-guide-line',
				'ri-h-1',
				'ri-h-2',
				'ri-h-3',
				'ri-h-4',
				'ri-h-5',
				'ri-h-6',
				'ri-hail-fill',
				'ri-hail-line',
				'ri-hammer-fill',
				'ri-hammer-line',
				'ri-hand-coin-fill',
				'ri-hand-coin-line',
				'ri-hand-heart-fill',
				'ri-hand-heart-line',
				'ri-hand-sanitizer-fill',
				'ri-hand-sanitizer-line',
				'ri-handbag-fill',
				'ri-handbag-line',
				'ri-hard-drive-2-fill',
				'ri-hard-drive-2-line',
				'ri-hard-drive-fill',
				'ri-hard-drive-line',
				'ri-hashtag',
				'ri-haze-2-fill',
				'ri-haze-2-line',
				'ri-haze-fill',
				'ri-haze-line',
				'ri-hd-fill',
				'ri-hd-line',
				'ri-heading',
				'ri-headphone-fill',
				'ri-headphone-line',
				'ri-health-book-fill',
				'ri-health-book-line',
				'ri-heart-2-fill',
				'ri-heart-2-line',
				'ri-heart-3-fill',
				'ri-heart-3-line',
				'ri-heart-add-fill',
				'ri-heart-add-line',
				'ri-heart-fill',
				'ri-heart-line',
				'ri-heart-pulse-fill',
				'ri-heart-pulse-line',
				'ri-hearts-fill',
				'ri-hearts-line',
				'ri-heavy-showers-fill',
				'ri-heavy-showers-line',
				'ri-history-fill',
				'ri-history-line',
				'ri-home-2-fill',
				'ri-home-2-line',
				'ri-home-3-fill',
				'ri-home-3-line',
				'ri-home-4-fill',
				'ri-home-4-line',
				'ri-home-5-fill',
				'ri-home-5-line',
				'ri-home-6-fill',
				'ri-home-6-line',
				'ri-home-7-fill',
				'ri-home-7-line',
				'ri-home-8-fill',
				'ri-home-8-line',
				'ri-home-fill',
				'ri-home-gear-fill',
				'ri-home-gear-line',
				'ri-home-heart-fill',
				'ri-home-heart-line',
				'ri-home-line',
				'ri-home-smile-2-fill',
				'ri-home-smile-2-line',
				'ri-home-smile-fill',
				'ri-home-smile-line',
				'ri-home-wifi-fill',
				'ri-home-wifi-line',
				'ri-honor-of-kings-fill',
				'ri-honor-of-kings-line',
				'ri-honour-fill',
				'ri-honour-line',
				'ri-hospital-fill',
				'ri-hospital-line',
				'ri-hotel-bed-fill',
				'ri-hotel-bed-line',
				'ri-hotel-fill',
				'ri-hotel-line',
				'ri-hotspot-fill',
				'ri-hotspot-line',
				'ri-hq-fill',
				'ri-hq-line',
				'ri-html5-fill',
				'ri-html5-line',
				'ri-ie-fill',
				'ri-ie-line',
				'ri-image-2-fill',
				'ri-image-2-line',
				'ri-image-add-fill',
				'ri-image-add-line',
				'ri-image-edit-fill',
				'ri-image-edit-line',
				'ri-image-fill',
				'ri-image-line',
				'ri-inbox-archive-fill',
				'ri-inbox-archive-line',
				'ri-inbox-fill',
				'ri-inbox-line',
				'ri-inbox-unarchive-fill',
				'ri-inbox-unarchive-line',
				'ri-increase-decrease-fill',
				'ri-increase-decrease-line',
				'ri-indent-decrease',
				'ri-indent-increase',
				'ri-indeterminate-circle-fill',
				'ri-indeterminate-circle-line',
				'ri-information-fill',
				'ri-information-line',
				'ri-infrared-thermometer-fill',
				'ri-infrared-thermometer-line',
				'ri-ink-bottle-fill',
				'ri-ink-bottle-line',
				'ri-input-cursor-move',
				'ri-input-method-fill',
				'ri-input-method-line',
				'ri-insert-column-left',
				'ri-insert-column-right',
				'ri-insert-row-bottom',
				'ri-insert-row-top',
				'ri-instagram-fill',
				'ri-instagram-line',
				'ri-install-fill',
				'ri-install-line',
				'ri-invision-fill',
				'ri-invision-line',
				'ri-italic',
				'ri-kakao-talk-fill',
				'ri-kakao-talk-line',
				'ri-key-2-fill',
				'ri-key-2-line',
				'ri-key-fill',
				'ri-key-line',
				'ri-keyboard-box-fill',
				'ri-keyboard-box-line',
				'ri-keyboard-fill',
				'ri-keyboard-line',
				'ri-keynote-fill',
				'ri-keynote-line',
				'ri-knife-blood-fill',
				'ri-knife-blood-line',
				'ri-knife-fill',
				'ri-knife-line',
				'ri-landscape-fill',
				'ri-landscape-line',
				'ri-layout-2-fill',
				'ri-layout-2-line',
				'ri-layout-3-fill',
				'ri-layout-3-line',
				'ri-layout-4-fill',
				'ri-layout-4-line',
				'ri-layout-5-fill',
				'ri-layout-5-line',
				'ri-layout-6-fill',
				'ri-layout-6-line',
				'ri-layout-bottom-2-fill',
				'ri-layout-bottom-2-line',
				'ri-layout-bottom-fill',
				'ri-layout-bottom-line',
				'ri-layout-column-fill',
				'ri-layout-column-line',
				'ri-layout-fill',
				'ri-layout-grid-fill',
				'ri-layout-grid-line',
				'ri-layout-left-2-fill',
				'ri-layout-left-2-line',
				'ri-layout-left-fill',
				'ri-layout-left-line',
				'ri-layout-line',
				'ri-layout-masonry-fill',
				'ri-layout-masonry-line',
				'ri-layout-right-2-fill',
				'ri-layout-right-2-line',
				'ri-layout-right-fill',
				'ri-layout-right-line',
				'ri-layout-row-fill',
				'ri-layout-row-line',
				'ri-layout-top-2-fill',
				'ri-layout-top-2-line',
				'ri-layout-top-fill',
				'ri-layout-top-line',
				'ri-leaf-fill',
				'ri-leaf-line',
				'ri-lifebuoy-fill',
				'ri-lifebuoy-line',
				'ri-lightbulb-fill',
				'ri-lightbulb-flash-fill',
				'ri-lightbulb-flash-line',
				'ri-lightbulb-line',
				'ri-line-chart-fill',
				'ri-line-chart-line',
				'ri-line-fill',
				'ri-line-height',
				'ri-line-line',
				'ri-link-m',
				'ri-link-unlink-m',
				'ri-link-unlink',
				'ri-link',
				'ri-linkedin-box-fill',
				'ri-linkedin-box-line',
				'ri-linkedin-fill',
				'ri-linkedin-line',
				'ri-links-fill',
				'ri-links-line',
				'ri-list-check-2',
				'ri-list-check',
				'ri-list-ordered',
				'ri-list-settings-fill',
				'ri-list-settings-line',
				'ri-list-unordered',
				'ri-live-fill',
				'ri-live-line',
				'ri-loader-2-fill',
				'ri-loader-2-line',
				'ri-loader-3-fill',
				'ri-loader-3-line',
				'ri-loader-4-fill',
				'ri-loader-4-line',
				'ri-loader-5-fill',
				'ri-loader-5-line',
				'ri-loader-fill',
				'ri-loader-line',
				'ri-lock-2-fill',
				'ri-lock-2-line',
				'ri-lock-fill',
				'ri-lock-line',
				'ri-lock-password-fill',
				'ri-lock-password-line',
				'ri-lock-unlock-fill',
				'ri-lock-unlock-line',
				'ri-login-box-fill',
				'ri-login-box-line',
				'ri-login-circle-fill',
				'ri-login-circle-line',
				'ri-logout-box-fill',
				'ri-logout-box-line',
				'ri-logout-box-r-fill',
				'ri-logout-box-r-line',
				'ri-logout-circle-fill',
				'ri-logout-circle-line',
				'ri-logout-circle-r-fill',
				'ri-logout-circle-r-line',
				'ri-luggage-cart-fill',
				'ri-luggage-cart-line',
				'ri-luggage-deposit-fill',
				'ri-luggage-deposit-line',
				'ri-lungs-fill',
				'ri-lungs-line',
				'ri-mac-fill',
				'ri-mac-line',
				'ri-macbook-fill',
				'ri-macbook-line',
				'ri-magic-fill',
				'ri-magic-line',
				'ri-mail-add-fill',
				'ri-mail-add-line',
				'ri-mail-check-fill',
				'ri-mail-check-line',
				'ri-mail-close-fill',
				'ri-mail-close-line',
				'ri-mail-download-fill',
				'ri-mail-download-line',
				'ri-mail-fill',
				'ri-mail-forbid-fill',
				'ri-mail-forbid-line',
				'ri-mail-line',
				'ri-mail-lock-fill',
				'ri-mail-lock-line',
				'ri-mail-open-fill',
				'ri-mail-open-line',
				'ri-mail-send-fill',
				'ri-mail-send-line',
				'ri-mail-settings-fill',
				'ri-mail-settings-line',
				'ri-mail-star-fill',
				'ri-mail-star-line',
				'ri-mail-unread-fill',
				'ri-mail-unread-line',
				'ri-mail-volume-fill',
				'ri-mail-volume-line',
				'ri-map-2-fill',
				'ri-map-2-line',
				'ri-map-fill',
				'ri-map-line',
				'ri-map-pin-2-fill',
				'ri-map-pin-2-line',
				'ri-map-pin-3-fill',
				'ri-map-pin-3-line',
				'ri-map-pin-4-fill',
				'ri-map-pin-4-line',
				'ri-map-pin-5-fill',
				'ri-map-pin-5-line',
				'ri-map-pin-add-fill',
				'ri-map-pin-add-line',
				'ri-map-pin-fill',
				'ri-map-pin-line',
				'ri-map-pin-range-fill',
				'ri-map-pin-range-line',
				'ri-map-pin-time-fill',
				'ri-map-pin-time-line',
				'ri-map-pin-user-fill',
				'ri-map-pin-user-line',
				'ri-mark-pen-fill',
				'ri-mark-pen-line',
				'ri-markdown-fill',
				'ri-markdown-line',
				'ri-markup-fill',
				'ri-markup-line',
				'ri-mastercard-fill',
				'ri-mastercard-line',
				'ri-mastodon-fill',
				'ri-mastodon-line',
				'ri-medal-2-fill',
				'ri-medal-2-line',
				'ri-medal-fill',
				'ri-medal-line',
				'ri-medicine-bottle-fill',
				'ri-medicine-bottle-line',
				'ri-medium-fill',
				'ri-medium-line',
				'ri-men-fill',
				'ri-men-line',
				'ri-mental-health-fill',
				'ri-mental-health-line',
				'ri-menu-2-fill',
				'ri-menu-2-line',
				'ri-menu-3-fill',
				'ri-menu-3-line',
				'ri-menu-4-fill',
				'ri-menu-4-line',
				'ri-menu-5-fill',
				'ri-menu-5-line',
				'ri-menu-add-fill',
				'ri-menu-add-line',
				'ri-menu-fill',
				'ri-menu-fold-fill',
				'ri-menu-fold-line',
				'ri-menu-line',
				'ri-menu-unfold-fill',
				'ri-menu-unfold-line',
				'ri-merge-cells-horizontal',
				'ri-merge-cells-vertical',
				'ri-message-2-fill',
				'ri-message-2-line',
				'ri-message-3-fill',
				'ri-message-3-line',
				'ri-message-fill',
				'ri-message-line',
				'ri-messenger-fill',
				'ri-messenger-line',
				'ri-meteor-fill',
				'ri-meteor-line',
				'ri-mic-2-fill',
				'ri-mic-2-line',
				'ri-mic-fill',
				'ri-mic-line',
				'ri-mic-off-fill',
				'ri-mic-off-line',
				'ri-mickey-fill',
				'ri-mickey-line',
				'ri-microscope-fill',
				'ri-microscope-line',
				'ri-microsoft-fill',
				'ri-microsoft-line',
				'ri-mind-map',
				'ri-mini-program-fill',
				'ri-mini-program-line',
				'ri-mist-fill',
				'ri-mist-line',
				'ri-money-cny-box-fill',
				'ri-money-cny-box-line',
				'ri-money-cny-circle-fill',
				'ri-money-cny-circle-line',
				'ri-money-dollar-box-fill',
				'ri-money-dollar-box-line',
				'ri-money-dollar-circle-fill',
				'ri-money-dollar-circle-line',
				'ri-money-euro-box-fill',
				'ri-money-euro-box-line',
				'ri-money-euro-circle-fill',
				'ri-money-euro-circle-line',
				'ri-money-pound-box-fill',
				'ri-money-pound-box-line',
				'ri-money-pound-circle-fill',
				'ri-money-pound-circle-line',
				'ri-moon-clear-fill',
				'ri-moon-clear-line',
				'ri-moon-cloudy-fill',
				'ri-moon-cloudy-line',
				'ri-moon-fill',
				'ri-moon-foggy-fill',
				'ri-moon-foggy-line',
				'ri-moon-line',
				'ri-more-2-fill',
				'ri-more-2-line',
				'ri-more-fill',
				'ri-more-line',
				'ri-motorbike-fill',
				'ri-motorbike-line',
				'ri-mouse-fill',
				'ri-mouse-line',
				'ri-movie-2-fill',
				'ri-movie-2-line',
				'ri-movie-fill',
				'ri-movie-line',
				'ri-music-2-fill',
				'ri-music-2-line',
				'ri-music-fill',
				'ri-music-line',
				'ri-mv-fill',
				'ri-mv-line',
				'ri-navigation-fill',
				'ri-navigation-line',
				'ri-netease-cloud-music-fill',
				'ri-netease-cloud-music-line',
				'ri-netflix-fill',
				'ri-netflix-line',
				'ri-newspaper-fill',
				'ri-newspaper-line',
				'ri-node-tree',
				'ri-notification-2-fill',
				'ri-notification-2-line',
				'ri-notification-3-fill',
				'ri-notification-3-line',
				'ri-notification-4-fill',
				'ri-notification-4-line',
				'ri-notification-badge-fill',
				'ri-notification-badge-line',
				'ri-notification-fill',
				'ri-notification-line',
				'ri-notification-off-fill',
				'ri-notification-off-line',
				'ri-npmjs-fill',
				'ri-npmjs-line',
				'ri-number-0',
				'ri-number-1',
				'ri-number-2',
				'ri-number-3',
				'ri-number-4',
				'ri-number-5',
				'ri-number-6',
				'ri-number-7',
				'ri-number-8',
				'ri-number-9',
				'ri-numbers-fill',
				'ri-numbers-line',
				'ri-nurse-fill',
				'ri-nurse-line',
				'ri-oil-fill',
				'ri-oil-line',
				'ri-omega',
				'ri-open-arm-fill',
				'ri-open-arm-line',
				'ri-open-source-fill',
				'ri-open-source-line',
				'ri-opera-fill',
				'ri-opera-line',
				'ri-order-play-fill',
				'ri-order-play-line',
				'ri-organization-chart',
				'ri-outlet-2-fill',
				'ri-outlet-2-line',
				'ri-outlet-fill',
				'ri-outlet-line',
				'ri-page-separator',
				'ri-pages-fill',
				'ri-pages-line',
				'ri-paint-brush-fill',
				'ri-paint-brush-line',
				'ri-paint-fill',
				'ri-paint-line',
				'ri-palette-fill',
				'ri-palette-line',
				'ri-pantone-fill',
				'ri-pantone-line',
				'ri-paragraph',
				'ri-parent-fill',
				'ri-parent-line',
				'ri-parentheses-fill',
				'ri-parentheses-line',
				'ri-parking-box-fill',
				'ri-parking-box-line',
				'ri-parking-fill',
				'ri-parking-line',
				'ri-passport-fill',
				'ri-passport-line',
				'ri-patreon-fill',
				'ri-patreon-line',
				'ri-pause-circle-fill',
				'ri-pause-circle-line',
				'ri-pause-fill',
				'ri-pause-line',
				'ri-pause-mini-fill',
				'ri-pause-mini-line',
				'ri-paypal-fill',
				'ri-paypal-line',
				'ri-pen-nib-fill',
				'ri-pen-nib-line',
				'ri-pencil-fill',
				'ri-pencil-line',
				'ri-pencil-ruler-2-fill',
				'ri-pencil-ruler-2-line',
				'ri-pencil-ruler-fill',
				'ri-pencil-ruler-line',
				'ri-percent-fill',
				'ri-percent-line',
				'ri-phone-camera-fill',
				'ri-phone-camera-line',
				'ri-phone-fill',
				'ri-phone-find-fill',
				'ri-phone-find-line',
				'ri-phone-line',
				'ri-phone-lock-fill',
				'ri-phone-lock-line',
				'ri-picture-in-picture-2-fill',
				'ri-picture-in-picture-2-line',
				'ri-picture-in-picture-exit-fill',
				'ri-picture-in-picture-exit-line',
				'ri-picture-in-picture-fill',
				'ri-picture-in-picture-line',
				'ri-pie-chart-2-fill',
				'ri-pie-chart-2-line',
				'ri-pie-chart-box-fill',
				'ri-pie-chart-box-line',
				'ri-pie-chart-fill',
				'ri-pie-chart-line',
				'ri-pin-distance-fill',
				'ri-pin-distance-line',
				'ri-ping-pong-fill',
				'ri-ping-pong-line',
				'ri-pinterest-fill',
				'ri-pinterest-line',
				'ri-pinyin-input',
				'ri-pixelfed-fill',
				'ri-pixelfed-line',
				'ri-plane-fill',
				'ri-plane-line',
				'ri-plant-fill',
				'ri-plant-line',
				'ri-play-circle-fill',
				'ri-play-circle-line',
				'ri-play-fill',
				'ri-play-line',
				'ri-play-list-2-fill',
				'ri-play-list-2-line',
				'ri-play-list-add-fill',
				'ri-play-list-add-line',
				'ri-play-list-fill',
				'ri-play-list-line',
				'ri-play-mini-fill',
				'ri-play-mini-line',
				'ri-playstation-fill',
				'ri-playstation-line',
				'ri-plug-2-fill',
				'ri-plug-2-line',
				'ri-plug-fill',
				'ri-plug-line',
				'ri-polaroid-2-fill',
				'ri-polaroid-2-line',
				'ri-polaroid-fill',
				'ri-polaroid-line',
				'ri-police-car-fill',
				'ri-police-car-line',
				'ri-price-tag-2-fill',
				'ri-price-tag-2-line',
				'ri-price-tag-3-fill',
				'ri-price-tag-3-line',
				'ri-price-tag-fill',
				'ri-price-tag-line',
				'ri-printer-cloud-fill',
				'ri-printer-cloud-line',
				'ri-printer-fill',
				'ri-printer-line',
				'ri-product-hunt-fill',
				'ri-product-hunt-line',
				'ri-profile-fill',
				'ri-profile-line',
				'ri-projector-2-fill',
				'ri-projector-2-line',
				'ri-projector-fill',
				'ri-projector-line',
				'ri-psychotherapy-fill',
				'ri-psychotherapy-line',
				'ri-pulse-fill',
				'ri-pulse-line',
				'ri-pushpin-2-fill',
				'ri-pushpin-2-line',
				'ri-pushpin-fill',
				'ri-pushpin-line',
				'ri-qq-fill',
				'ri-qq-line',
				'ri-qr-code-fill',
				'ri-qr-code-line',
				'ri-qr-scan-2-fill',
				'ri-qr-scan-2-line',
				'ri-qr-scan-fill',
				'ri-qr-scan-line',
				'ri-question-answer-fill',
				'ri-question-answer-line',
				'ri-question-fill',
				'ri-question-line',
				'ri-question-mark',
				'ri-questionnaire-fill',
				'ri-questionnaire-line',
				'ri-quill-pen-fill',
				'ri-quill-pen-line',
				'ri-radar-fill',
				'ri-radar-line',
				'ri-radio-2-fill',
				'ri-radio-2-line',
				'ri-radio-button-fill',
				'ri-radio-button-line',
				'ri-radio-fill',
				'ri-radio-line',
				'ri-rainbow-fill',
				'ri-rainbow-line',
				'ri-rainy-fill',
				'ri-rainy-line',
				'ri-reactjs-fill',
				'ri-reactjs-line',
				'ri-record-circle-fill',
				'ri-record-circle-line',
				'ri-record-mail-fill',
				'ri-record-mail-line',
				'ri-recycle-fill',
				'ri-recycle-line',
				'ri-red-packet-fill',
				'ri-red-packet-line',
				'ri-reddit-fill',
				'ri-reddit-line',
				'ri-refresh-fill',
				'ri-refresh-line',
				'ri-refund-2-fill',
				'ri-refund-2-line',
				'ri-refund-fill',
				'ri-refund-line',
				'ri-registered-fill',
				'ri-registered-line',
				'ri-remixicon-fill',
				'ri-remixicon-line',
				'ri-remote-control-2-fill',
				'ri-remote-control-2-line',
				'ri-remote-control-fill',
				'ri-remote-control-line',
				'ri-repeat-2-fill',
				'ri-repeat-2-line',
				'ri-repeat-fill',
				'ri-repeat-line',
				'ri-repeat-one-fill',
				'ri-repeat-one-line',
				'ri-reply-all-fill',
				'ri-reply-all-line',
				'ri-reply-fill',
				'ri-reply-line',
				'ri-reserved-fill',
				'ri-reserved-line',
				'ri-rest-time-fill',
				'ri-rest-time-line',
				'ri-restart-fill',
				'ri-restart-line',
				'ri-restaurant-2-fill',
				'ri-restaurant-2-line',
				'ri-restaurant-fill',
				'ri-restaurant-line',
				'ri-rewind-fill',
				'ri-rewind-line',
				'ri-rewind-mini-fill',
				'ri-rewind-mini-line',
				'ri-rhythm-fill',
				'ri-rhythm-line',
				'ri-riding-fill',
				'ri-riding-line',
				'ri-road-map-fill',
				'ri-road-map-line',
				'ri-roadster-fill',
				'ri-roadster-line',
				'ri-robot-fill',
				'ri-robot-line',
				'ri-rocket-2-fill',
				'ri-rocket-2-line',
				'ri-rocket-fill',
				'ri-rocket-line',
				'ri-rotate-lock-fill',
				'ri-rotate-lock-line',
				'ri-rounded-corner',
				'ri-route-fill',
				'ri-route-line',
				'ri-router-fill',
				'ri-router-line',
				'ri-rss-fill',
				'ri-rss-line',
				'ri-ruler-2-fill',
				'ri-ruler-2-line',
				'ri-ruler-fill',
				'ri-ruler-line',
				'ri-run-fill',
				'ri-run-line',
				'ri-safari-fill',
				'ri-safari-line',
				'ri-safe-2-fill',
				'ri-safe-2-line',
				'ri-safe-fill',
				'ri-safe-line',
				'ri-sailboat-fill',
				'ri-sailboat-line',
				'ri-save-2-fill',
				'ri-save-2-line',
				'ri-save-3-fill',
				'ri-save-3-line',
				'ri-save-fill',
				'ri-save-line',
				'ri-scales-2-fill',
				'ri-scales-2-line',
				'ri-scales-3-fill',
				'ri-scales-3-line',
				'ri-scales-fill',
				'ri-scales-line',
				'ri-scan-2-fill',
				'ri-scan-2-line',
				'ri-scan-fill',
				'ri-scan-line',
				'ri-scissors-2-fill',
				'ri-scissors-2-line',
				'ri-scissors-cut-fill',
				'ri-scissors-cut-line',
				'ri-scissors-fill',
				'ri-scissors-line',
				'ri-screenshot-2-fill',
				'ri-screenshot-2-line',
				'ri-screenshot-fill',
				'ri-screenshot-line',
				'ri-sd-card-fill',
				'ri-sd-card-line',
				'ri-sd-card-mini-fill',
				'ri-sd-card-mini-line',
				'ri-search-2-fill',
				'ri-search-2-line',
				'ri-search-eye-fill',
				'ri-search-eye-line',
				'ri-search-fill',
				'ri-search-line',
				'ri-secure-payment-fill',
				'ri-secure-payment-line',
				'ri-seedling-fill',
				'ri-seedling-line',
				'ri-send-backward',
				'ri-send-plane-2-fill',
				'ri-send-plane-2-line',
				'ri-send-plane-fill',
				'ri-send-plane-line',
				'ri-send-to-back',
				'ri-sensor-fill',
				'ri-sensor-line',
				'ri-separator',
				'ri-server-fill',
				'ri-server-line',
				'ri-service-fill',
				'ri-service-line',
				'ri-settings-2-fill',
				'ri-settings-2-line',
				'ri-settings-3-fill',
				'ri-settings-3-line',
				'ri-settings-4-fill',
				'ri-settings-4-line',
				'ri-settings-5-fill',
				'ri-settings-5-line',
				'ri-settings-6-fill',
				'ri-settings-6-line',
				'ri-settings-fill',
				'ri-settings-line',
				'ri-shape-2-fill',
				'ri-shape-2-line',
				'ri-shape-fill',
				'ri-shape-line',
				'ri-share-box-fill',
				'ri-share-box-line',
				'ri-share-circle-fill',
				'ri-share-circle-line',
				'ri-share-fill',
				'ri-share-forward-2-fill',
				'ri-share-forward-2-line',
				'ri-share-forward-box-fill',
				'ri-share-forward-box-line',
				'ri-share-forward-fill',
				'ri-share-forward-line',
				'ri-share-line',
				'ri-shield-check-fill',
				'ri-shield-check-line',
				'ri-shield-cross-fill',
				'ri-shield-cross-line',
				'ri-shield-fill',
				'ri-shield-flash-fill',
				'ri-shield-flash-line',
				'ri-shield-keyhole-fill',
				'ri-shield-keyhole-line',
				'ri-shield-line',
				'ri-shield-star-fill',
				'ri-shield-star-line',
				'ri-shield-user-fill',
				'ri-shield-user-line',
				'ri-ship-2-fill',
				'ri-ship-2-line',
				'ri-ship-fill',
				'ri-ship-line',
				'ri-shirt-fill',
				'ri-shirt-line',
				'ri-shopping-bag-2-fill',
				'ri-shopping-bag-2-line',
				'ri-shopping-bag-3-fill',
				'ri-shopping-bag-3-line',
				'ri-shopping-bag-fill',
				'ri-shopping-bag-line',
				'ri-shopping-basket-2-fill',
				'ri-shopping-basket-2-line',
				'ri-shopping-basket-fill',
				'ri-shopping-basket-line',
				'ri-shopping-cart-2-fill',
				'ri-shopping-cart-2-line',
				'ri-shopping-cart-fill',
				'ri-shopping-cart-line',
				'ri-showers-fill',
				'ri-showers-line',
				'ri-shuffle-fill',
				'ri-shuffle-line',
				'ri-shut-down-fill',
				'ri-shut-down-line',
				'ri-side-bar-fill',
				'ri-side-bar-line',
				'ri-signal-tower-fill',
				'ri-signal-tower-line',
				'ri-signal-wifi-1-fill',
				'ri-signal-wifi-1-line',
				'ri-signal-wifi-2-fill',
				'ri-signal-wifi-2-line',
				'ri-signal-wifi-3-fill',
				'ri-signal-wifi-3-line',
				'ri-signal-wifi-error-fill',
				'ri-signal-wifi-error-line',
				'ri-signal-wifi-fill',
				'ri-signal-wifi-line',
				'ri-signal-wifi-off-fill',
				'ri-signal-wifi-off-line',
				'ri-sim-card-2-fill',
				'ri-sim-card-2-line',
				'ri-sim-card-fill',
				'ri-sim-card-line',
				'ri-single-quotes-l',
				'ri-single-quotes-r',
				'ri-sip-fill',
				'ri-sip-line',
				'ri-skip-back-fill',
				'ri-skip-back-line',
				'ri-skip-back-mini-fill',
				'ri-skip-back-mini-line',
				'ri-skip-forward-fill',
				'ri-skip-forward-line',
				'ri-skip-forward-mini-fill',
				'ri-skip-forward-mini-line',
				'ri-skull-2-fill',
				'ri-skull-2-line',
				'ri-skull-fill',
				'ri-skull-line',
				'ri-skype-fill',
				'ri-skype-line',
				'ri-slack-fill',
				'ri-slack-line',
				'ri-slice-fill',
				'ri-slice-line',
				'ri-slideshow-2-fill',
				'ri-slideshow-2-line',
				'ri-slideshow-3-fill',
				'ri-slideshow-3-line',
				'ri-slideshow-4-fill',
				'ri-slideshow-4-line',
				'ri-slideshow-fill',
				'ri-slideshow-line',
				'ri-smartphone-fill',
				'ri-smartphone-line',
				'ri-snapchat-fill',
				'ri-snapchat-line',
				'ri-snowy-fill',
				'ri-snowy-line',
				'ri-sort-asc',
				'ri-sort-desc',
				'ri-sound-module-fill',
				'ri-sound-module-line',
				'ri-soundcloud-fill',
				'ri-soundcloud-line',
				'ri-space-ship-fill',
				'ri-space-ship-line',
				'ri-space',
				'ri-spam-2-fill',
				'ri-spam-2-line',
				'ri-spam-3-fill',
				'ri-spam-3-line',
				'ri-spam-fill',
				'ri-spam-line',
				'ri-speaker-2-fill',
				'ri-speaker-2-line',
				'ri-speaker-3-fill',
				'ri-speaker-3-line',
				'ri-speaker-fill',
				'ri-speaker-line',
				'ri-spectrum-fill',
				'ri-spectrum-line',
				'ri-speed-fill',
				'ri-speed-line',
				'ri-speed-mini-fill',
				'ri-speed-mini-line',
				'ri-split-cells-horizontal',
				'ri-split-cells-vertical',
				'ri-spotify-fill',
				'ri-spotify-line',
				'ri-spy-fill',
				'ri-spy-line',
				'ri-stack-fill',
				'ri-stack-line',
				'ri-stack-overflow-fill',
				'ri-stack-overflow-line',
				'ri-stackshare-fill',
				'ri-stackshare-line',
				'ri-star-fill',
				'ri-star-half-fill',
				'ri-star-half-line',
				'ri-star-half-s-fill',
				'ri-star-half-s-line',
				'ri-star-line',
				'ri-star-s-fill',
				'ri-star-s-line',
				'ri-star-smile-fill',
				'ri-star-smile-line',
				'ri-steam-fill',
				'ri-steam-line',
				'ri-steering-2-fill',
				'ri-steering-2-line',
				'ri-steering-fill',
				'ri-steering-line',
				'ri-stethoscope-fill',
				'ri-stethoscope-line',
				'ri-sticky-note-2-fill',
				'ri-sticky-note-2-line',
				'ri-sticky-note-fill',
				'ri-sticky-note-line',
				'ri-stock-fill',
				'ri-stock-line',
				'ri-stop-circle-fill',
				'ri-stop-circle-line',
				'ri-stop-fill',
				'ri-stop-line',
				'ri-stop-mini-fill',
				'ri-stop-mini-line',
				'ri-store-2-fill',
				'ri-store-2-line',
				'ri-store-3-fill',
				'ri-store-3-line',
				'ri-store-fill',
				'ri-store-line',
				'ri-strikethrough-2',
				'ri-strikethrough',
				'ri-subscript-2',
				'ri-subscript',
				'ri-subtract-fill',
				'ri-subtract-line',
				'ri-subway-fill',
				'ri-subway-line',
				'ri-subway-wifi-fill',
				'ri-subway-wifi-line',
				'ri-suitcase-2-fill',
				'ri-suitcase-2-line',
				'ri-suitcase-3-fill',
				'ri-suitcase-3-line',
				'ri-suitcase-fill',
				'ri-suitcase-line',
				'ri-sun-cloudy-fill',
				'ri-sun-cloudy-line',
				'ri-sun-fill',
				'ri-sun-foggy-fill',
				'ri-sun-foggy-line',
				'ri-sun-line',
				'ri-superscript-2',
				'ri-superscript',
				'ri-surgical-mask-fill',
				'ri-surgical-mask-line',
				'ri-surround-sound-fill',
				'ri-surround-sound-line',
				'ri-survey-fill',
				'ri-survey-line',
				'ri-swap-box-fill',
				'ri-swap-box-line',
				'ri-swap-fill',
				'ri-swap-line',
				'ri-switch-fill',
				'ri-switch-line',
				'ri-sword-fill',
				'ri-sword-line',
				'ri-syringe-fill',
				'ri-syringe-line',
				'ri-t-box-fill',
				'ri-t-box-line',
				'ri-t-shirt-2-fill',
				'ri-t-shirt-2-line',
				'ri-t-shirt-air-fill',
				'ri-t-shirt-air-line',
				'ri-t-shirt-fill',
				'ri-t-shirt-line',
				'ri-table-2',
				'ri-table-alt-fill',
				'ri-table-alt-line',
				'ri-table-fill',
				'ri-table-line',
				'ri-tablet-fill',
				'ri-tablet-line',
				'ri-takeaway-fill',
				'ri-takeaway-line',
				'ri-taobao-fill',
				'ri-taobao-line',
				'ri-tape-fill',
				'ri-tape-line',
				'ri-task-fill',
				'ri-task-line',
				'ri-taxi-fill',
				'ri-taxi-line',
				'ri-taxi-wifi-fill',
				'ri-taxi-wifi-line',
				'ri-team-fill',
				'ri-team-line',
				'ri-telegram-fill',
				'ri-telegram-line',
				'ri-temp-cold-fill',
				'ri-temp-cold-line',
				'ri-temp-hot-fill',
				'ri-temp-hot-line',
				'ri-terminal-box-fill',
				'ri-terminal-box-line',
				'ri-terminal-fill',
				'ri-terminal-line',
				'ri-terminal-window-fill',
				'ri-terminal-window-line',
				'ri-test-tube-fill',
				'ri-test-tube-line',
				'ri-text-direction-l',
				'ri-text-direction-r',
				'ri-text-spacing',
				'ri-text-wrap',
				'ri-text',
				'ri-thermometer-fill',
				'ri-thermometer-line',
				'ri-thumb-down-fill',
				'ri-thumb-down-line',
				'ri-thumb-up-fill',
				'ri-thumb-up-line',
				'ri-thunderstorms-fill',
				'ri-thunderstorms-line',
				'ri-ticket-2-fill',
				'ri-ticket-2-line',
				'ri-ticket-fill',
				'ri-ticket-line',
				'ri-time-fill',
				'ri-time-line',
				'ri-timer-2-fill',
				'ri-timer-2-line',
				'ri-timer-fill',
				'ri-timer-flash-fill',
				'ri-timer-flash-line',
				'ri-timer-line',
				'ri-todo-fill',
				'ri-todo-line',
				'ri-toggle-fill',
				'ri-toggle-line',
				'ri-tools-fill',
				'ri-tools-line',
				'ri-tornado-fill',
				'ri-tornado-line',
				'ri-trademark-fill',
				'ri-trademark-line',
				'ri-traffic-light-fill',
				'ri-traffic-light-line',
				'ri-train-fill',
				'ri-train-line',
				'ri-train-wifi-fill',
				'ri-train-wifi-line',
				'ri-translate-2',
				'ri-translate',
				'ri-travesti-fill',
				'ri-travesti-line',
				'ri-treasure-map-fill',
				'ri-treasure-map-line',
				'ri-trello-fill',
				'ri-trello-line',
				'ri-trophy-fill',
				'ri-trophy-line',
				'ri-truck-fill',
				'ri-truck-line',
				'ri-tumblr-fill',
				'ri-tumblr-line',
				'ri-tv-2-fill',
				'ri-tv-2-line',
				'ri-tv-fill',
				'ri-tv-line',
				'ri-twitch-fill',
				'ri-twitch-line',
				'ri-twitter-fill',
				'ri-twitter-line',
				'ri-typhoon-fill',
				'ri-typhoon-line',
				'ri-u-disk-fill',
				'ri-u-disk-line',
				'ri-ubuntu-fill',
				'ri-ubuntu-line',
				'ri-umbrella-fill',
				'ri-umbrella-line',
				'ri-underline',
				'ri-uninstall-fill',
				'ri-uninstall-line',
				'ri-unsplash-fill',
				'ri-unsplash-line',
				'ri-upload-2-fill',
				'ri-upload-2-line',
				'ri-upload-cloud-2-fill',
				'ri-upload-cloud-2-line',
				'ri-upload-cloud-fill',
				'ri-upload-cloud-line',
				'ri-upload-fill',
				'ri-upload-line',
				'ri-usb-fill',
				'ri-usb-line',
				'ri-user-2-fill',
				'ri-user-2-line',
				'ri-user-3-fill',
				'ri-user-3-line',
				'ri-user-4-fill',
				'ri-user-4-line',
				'ri-user-5-fill',
				'ri-user-5-line',
				'ri-user-6-fill',
				'ri-user-6-line',
				'ri-user-add-fill',
				'ri-user-add-line',
				'ri-user-fill',
				'ri-user-follow-fill',
				'ri-user-follow-line',
				'ri-user-heart-fill',
				'ri-user-heart-line',
				'ri-user-line',
				'ri-user-location-fill',
				'ri-user-location-line',
				'ri-user-received-2-fill',
				'ri-user-received-2-line',
				'ri-user-received-fill',
				'ri-user-received-line',
				'ri-user-search-fill',
				'ri-user-search-line',
				'ri-user-settings-fill',
				'ri-user-settings-line',
				'ri-user-shared-2-fill',
				'ri-user-shared-2-line',
				'ri-user-shared-fill',
				'ri-user-shared-line',
				'ri-user-smile-fill',
				'ri-user-smile-line',
				'ri-user-star-fill',
				'ri-user-star-line',
				'ri-user-unfollow-fill',
				'ri-user-unfollow-line',
				'ri-user-voice-fill',
				'ri-user-voice-line',
				'ri-video-add-fill',
				'ri-video-add-line',
				'ri-video-chat-fill',
				'ri-video-chat-line',
				'ri-video-download-fill',
				'ri-video-download-line',
				'ri-video-fill',
				'ri-video-line',
				'ri-video-upload-fill',
				'ri-video-upload-line',
				'ri-vidicon-2-fill',
				'ri-vidicon-2-line',
				'ri-vidicon-fill',
				'ri-vidicon-line',
				'ri-vimeo-fill',
				'ri-vimeo-line',
				'ri-vip-crown-2-fill',
				'ri-vip-crown-2-line',
				'ri-vip-crown-fill',
				'ri-vip-crown-line',
				'ri-vip-diamond-fill',
				'ri-vip-diamond-line',
				'ri-vip-fill',
				'ri-vip-line',
				'ri-virus-fill',
				'ri-virus-line',
				'ri-visa-fill',
				'ri-visa-line',
				'ri-voice-recognition-fill',
				'ri-voice-recognition-line',
				'ri-voiceprint-fill',
				'ri-voiceprint-line',
				'ri-volume-down-fill',
				'ri-volume-down-line',
				'ri-volume-mute-fill',
				'ri-volume-mute-line',
				'ri-volume-off-vibrate-fill',
				'ri-volume-off-vibrate-line',
				'ri-volume-up-fill',
				'ri-volume-up-line',
				'ri-volume-vibrate-fill',
				'ri-volume-vibrate-line',
				'ri-vuejs-fill',
				'ri-vuejs-line',
				'ri-walk-fill',
				'ri-walk-line',
				'ri-wallet-2-fill',
				'ri-wallet-2-line',
				'ri-wallet-3-fill',
				'ri-wallet-3-line',
				'ri-wallet-fill',
				'ri-wallet-line',
				'ri-water-flash-fill',
				'ri-water-flash-line',
				'ri-webcam-fill',
				'ri-webcam-line',
				'ri-wechat-2-fill',
				'ri-wechat-2-line',
				'ri-wechat-fill',
				'ri-wechat-line',
				'ri-wechat-pay-fill',
				'ri-wechat-pay-line',
				'ri-weibo-fill',
				'ri-weibo-line',
				'ri-whatsapp-fill',
				'ri-whatsapp-line',
				'ri-wheelchair-fill',
				'ri-wheelchair-line',
				'ri-wifi-fill',
				'ri-wifi-line',
				'ri-wifi-off-fill',
				'ri-wifi-off-line',
				'ri-window-2-fill',
				'ri-window-2-line',
				'ri-window-fill',
				'ri-window-line',
				'ri-windows-fill',
				'ri-windows-line',
				'ri-windy-fill',
				'ri-windy-line',
				'ri-wireless-charging-fill',
				'ri-wireless-charging-line',
				'ri-women-fill',
				'ri-women-line',
				'ri-wubi-input',
				'ri-xbox-fill',
				'ri-xbox-line',
				'ri-xing-fill',
				'ri-xing-line',
				'ri-youtube-fill',
				'ri-youtube-line',
				'ri-zcool-fill',
				'ri-zcool-line',
				'ri-zhihu-fill',
				'ri-zhihu-line',
				'ri-zoom-in-fill',
				'ri-zoom-in-line',
				'ri-zoom-out-fill',
				'ri-zoom-out-line',
				'ri-zzz-fill',
				'ri-zzz-line',
			);

			return $remix_icons;
		}
	}
}