<?php
// Icon

$icon_html = '';
$custom_icon_enabled = get_post_meta( get_the_ID(), 'dsvy-custom-icon-enabled', true ); 
if( $custom_icon_enabled=='1' ){
	$img_src = '';
	$custom_icon_url = get_post_meta( get_the_ID(), 'dsvy-custom-icon', true );
	if( !empty($custom_icon_url) ){
		$img_src = wp_get_attachment_image_src($custom_icon_url, 'full');
		if( !empty($img_src[0]) ){ $custom_icon_url = $img_src[0]; }
	}
	$icon_html = '<img src="'.$custom_icon_url.'"/>';
}else{
	$icon_lib = get_post_meta( get_the_ID(), 'dsvy-service-icon-library', true );
	wp_enqueue_style($icon_lib);
	$icon_class = get_post_meta( get_the_ID(), 'dsvy-service-icon-'.$icon_lib, true );
	if( !empty($icon_class) ){
		$icon_html = '<i class="'.esc_attr($icon_class).'"></i>';
	}
}

// Read More text
if( !isset($more_text) ){
	$more_text = esc_attr__('Read More','cardioly');
}
?>
<div class="designervily-post-item">
	<div class="designervily-box-content">
		<?php if( $custom_icon_enabled=='1' ): ?>
			<div class="dsvy-service-custom-icon-wrapper">
			<?php else: ?>
		<div class="dsvy-service-icon-wrapper">
		<?php endif; ?>
			<?php echo dsvy_esc_kses($icon_html); ?>
		</div>	
		<div class="designervily-box-content-inner">
			<div class="dsvy-service-cat"><?php echo get_the_term_list( get_the_ID(), 'dsvy-service-category', '', ', ' ); ?></div>
			<h3 class="dsvy-service-title"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3> 
			<div class="dsvy-service-btn">
				<a class="dsvy-service-btn-a" href="<?php the_permalink(); ?>"><span><?php echo esc_html($more_text); ?></span></a>
			</div>
		</div>
	</div>
</div>